/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.UnavailableException;

public interface AvailabilityGuard {
    public static final AvailabilityGuard NOT_AVAILABLE_GUARD = new NotAvailableGuard();

    public void require(AvailabilityRequirement var1);

    public void fulfill(AvailabilityRequirement var1);

    public boolean isAvailable();

    public boolean isShutdown();

    public boolean isAvailable(long var1);

    public void await(long var1) throws UnavailableException;

    public void addListener(AvailabilityListener var1);

    public void removeListener(AvailabilityListener var1);

    public String describe();

    public static class NotAvailableGuard
    implements AvailabilityGuard {
        private static final String ALWAYS_NOT_AVAILABLE_GUARD = "Always not available guard";

        private NotAvailableGuard() {
        }

        @Override
        public void require(AvailabilityRequirement requirement) {
        }

        @Override
        public void fulfill(AvailabilityRequirement requirement) {
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isAvailable(long millis) {
            return false;
        }

        @Override
        public void await(long millis) throws UnavailableException {
        }

        @Override
        public void addListener(AvailabilityListener listener) {
        }

        @Override
        public void removeListener(AvailabilityListener listener) {
        }

        @Override
        public String describe() {
            return ALWAYS_NOT_AVAILABLE_GUARD;
        }
    }
}

