/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.nio.file.Path;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.logging.InternalLogProvider;

public final class FileCountThreshold
implements Threshold {
    private final long maxNonEmptyLogs;
    private final EntryCountThreshold entryCountThreshold;
    private long nonEmptyLogCount;

    FileCountThreshold(long maxNonEmptyLogs, InternalLogProvider logProvider) {
        this.maxNonEmptyLogs = maxNonEmptyLogs;
        this.entryCountThreshold = new EntryCountThreshold(logProvider, 1L);
    }

    @Override
    public void init() {
        this.nonEmptyLogCount = 0L;
        this.entryCountThreshold.init();
    }

    @Override
    public boolean reached(Path file, long version, LogFileInformation source) {
        return ++this.nonEmptyLogCount >= this.maxNonEmptyLogs && this.entryCountThreshold.reached(file, version, source);
    }

    public String toString() {
        return this.maxNonEmptyLogs + " files";
    }
}

