/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.neo4j.internal.kernel.api.LabelsSupplier;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.impl.api.security.WrappedAccessMode;
import org.neo4j.messages.MessageUtil;
import org.neo4j.storageengine.api.PropertySelection;

public class RestrictedAccessMode
extends WrappedAccessMode {
    public RestrictedAccessMode(AccessMode original, StaticAccessMode restricting) {
        super(original, restricting);
    }

    public boolean allowsWrites() {
        return this.original.allowsWrites() && this.wrapping.allowsWrites();
    }

    public PermissionState allowsTokenCreates(PrivilegeAction action) {
        return this.original.allowsTokenCreates(action).restrict(this.wrapping.allowsTokenCreates(action));
    }

    public boolean allowsSchemaWrites() {
        return this.original.allowsSchemaWrites() && this.wrapping.allowsSchemaWrites();
    }

    public PermissionState allowsSchemaWrites(PrivilegeAction action) {
        return this.original.allowsSchemaWrites(action).restrict(this.wrapping.allowsSchemaWrites(action));
    }

    public boolean allowsShowIndex() {
        return this.original.allowsShowIndex() && this.wrapping.allowsShowIndex();
    }

    public boolean allowsShowConstraint() {
        return this.original.allowsShowConstraint() && this.wrapping.allowsShowConstraint();
    }

    public boolean allowsTraverseAllLabels() {
        return this.original.allowsTraverseAllLabels() && this.wrapping.allowsTraverseAllLabels();
    }

    public boolean allowsTraverseAllNodesWithLabel(int label) {
        return this.original.allowsTraverseAllNodesWithLabel(label) && this.wrapping.allowsTraverseAllNodesWithLabel(label);
    }

    public boolean disallowsTraverseLabel(int label) {
        return this.original.disallowsTraverseLabel(label) || this.wrapping.disallowsTraverseLabel(label);
    }

    public boolean allowsTraverseNode(int ... labels) {
        return this.original.allowsTraverseNode(labels) && this.wrapping.allowsTraverseNode(labels);
    }

    public boolean hasApplicableTraverseNodeAllowPropertyRules(int label) {
        return this.original.hasApplicableTraverseNodeAllowPropertyRules(label) || this.wrapping.hasApplicableTraverseNodeAllowPropertyRules(label);
    }

    public boolean allowsTraverseNode(LabelsSupplier labels, SelectedPropertiesProvider selectedPropertiesProvider) {
        return this.original.allowsTraverseNode(labels, selectedPropertiesProvider) && this.wrapping.allowsTraverseNode(labels, selectedPropertiesProvider);
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.original.allowsTraverseAllRelTypes() && this.wrapping.allowsTraverseAllRelTypes();
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.original.allowsTraverseRelType(relType) && this.wrapping.allowsTraverseRelType(relType);
    }

    public boolean allowsTraverseAllRelsWithType(int relType) {
        return this.original.allowsTraverseAllRelsWithType(relType) && this.wrapping.allowsTraverseAllRelsWithType(relType);
    }

    public boolean disallowsTraverseRelType(int relType) {
        return this.original.disallowsTraverseRelType(relType) && this.wrapping.disallowsTraverseRelType(relType);
    }

    public boolean hasApplicableTraverseRelAllowPropertyRules(int type) {
        return this.original.hasApplicableTraverseRelAllowPropertyRules(type) || this.wrapping.hasApplicableTraverseRelAllowPropertyRules(type);
    }

    public boolean allowsTraverseRelationship(int type, SelectedPropertiesProvider propertyProviderSupplier) {
        return this.original.allowsTraverseRelationship(type, propertyProviderSupplier) && this.wrapping.allowsTraverseRelationship(type, propertyProviderSupplier);
    }

    public boolean allowsReadNodeProperties(LabelsSupplier labels, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.original.allowsReadNodeProperties(labels, propertyKeys, propertyProvider) && this.wrapping.allowsReadNodeProperties(labels, propertyKeys, propertyProvider);
    }

    public IntPredicate allowedToReadNodeProperties(LabelsSupplier labels, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return this.original.allowedToReadNodeProperties(labels, propertyProvider, selection).and(this.wrapping.allowedToReadNodeProperties(labels, propertyProvider, selection));
    }

    public IntPredicate allowedToReadRelationshipProperties(RelTypeSupplier relType, Supplier<SelectedPropertiesProvider> propertyProvider, PropertySelection selection) {
        return this.original.allowedToReadRelationshipProperties(relType, propertyProvider, selection).and(this.wrapping.allowedToReadRelationshipProperties(relType, propertyProvider, selection));
    }

    public boolean allowsTraverseAndReadAllMatchingNodeProperties(int[] labels, int[] propertyKeys) {
        return this.original.allowsTraverseAndReadAllMatchingNodeProperties(labels, propertyKeys) && this.wrapping.allowsTraverseAndReadAllMatchingNodeProperties(labels, propertyKeys);
    }

    public boolean allowsTraverseAndReadAllMatchingRelProperties(int[] relTypes, int[] propertyKeys) {
        return this.original.allowsTraverseAndReadAllMatchingRelProperties(relTypes, propertyKeys) && this.wrapping.allowsTraverseAndReadAllMatchingRelProperties(relTypes, propertyKeys);
    }

    public boolean allowsReadRelProperties(RelTypeSupplier relType, int[] propertyKeys, Supplier<SelectedPropertiesProvider> propertyProvider) {
        return this.original.allowsReadRelProperties(relType, propertyKeys, propertyProvider) && this.wrapping.allowsReadRelProperties(relType, propertyKeys, propertyProvider);
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.original.allowsSeePropertyKeyToken(propertyKey) && this.wrapping.allowsSeePropertyKeyToken(propertyKey);
    }

    public PermissionState allowsShowSetting(String setting) {
        return this.original.allowsShowSetting(setting).restrict(this.wrapping.allowsShowSetting(setting));
    }

    public boolean allowsSetLabel(int labelId) {
        return this.original.allowsSetLabel(labelId) && this.wrapping.allowsSetLabel(labelId);
    }

    public boolean allowsRemoveLabel(int labelId) {
        return this.original.allowsRemoveLabel(labelId) && this.wrapping.allowsRemoveLabel(labelId);
    }

    public boolean allowsCreateNode(int[] labelIds) {
        return this.original.allowsCreateNode(labelIds) && this.wrapping.allowsCreateNode(labelIds);
    }

    public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
        return this.original.allowsDeleteNode(labelSupplier) && this.wrapping.allowsDeleteNode(labelSupplier);
    }

    public boolean allowsCreateRelationship(int relType) {
        return this.original.allowsCreateRelationship(relType) && this.wrapping.allowsCreateRelationship(relType);
    }

    public boolean allowsDeleteRelationship(int relType) {
        return this.original.allowsDeleteRelationship(relType) && this.wrapping.allowsDeleteRelationship(relType);
    }

    public boolean allowsSetProperty(LabelsSupplier labels, int propertyKey) {
        return this.original.allowsSetProperty(labels, propertyKey) && this.wrapping.allowsSetProperty(labels, propertyKey);
    }

    public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
        return this.original.allowsSetProperty(relType, propertyKey) && this.wrapping.allowsSetProperty(relType, propertyKey);
    }

    public PermissionState allowsLoadAllData() {
        return this.original.allowsLoadAllData().restrict(this.wrapping.allowsLoadAllData());
    }

    public PermissionState allowsLoadUri(URI url, InetAddress inetAddress) {
        return this.original.allowsLoadUri(url, inetAddress).restrict(this.wrapping.allowsLoadUri(url, inetAddress));
    }

    public String name() {
        return MessageUtil.restrictedMode((String)this.original.name(), (String)this.wrapping.name());
    }

    private static PropertySelection combinePropertySelections(PropertySelection originalSelection, PropertySelection wrappingSelection) {
        int i;
        MutableIntSet union = IntSets.mutable.empty();
        for (i = 0; i < originalSelection.numberOfKeys(); ++i) {
            union.add(originalSelection.key(i));
        }
        for (i = 0; i < wrappingSelection.numberOfKeys(); ++i) {
            union.add(wrappingSelection.key(i));
        }
        return PropertySelection.selection((int[])union.toArray());
    }
}

