/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class DatabaseSchemaState
implements SchemaState {
    private final Map<Object, Object> state = new ConcurrentHashMap<Object, Object>();
    private final InternalLog log;

    public DatabaseSchemaState(InternalLogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    public <K, V> V get(K key) {
        return (V)this.state.get(key);
    }

    public <K, V> V getOrCreate(K key, Function<K, V> creator) {
        return (V)this.state.computeIfAbsent(key, creator);
    }

    public <K, V> void put(K key, V value) {
        this.state.put(key, value);
    }

    public void clear() {
        this.state.clear();
        this.log.debug("Schema state store has been cleared.");
    }
}

