/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.enrichment;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.impl.factory.primitive.ByteObjectMaps;
import org.neo4j.internal.helpers.TimeUtil;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public enum ValuesReader {
    NO_VALUE(1, NoValue.class, unused -> Values.NO_VALUE),
    BOOLEAN(2, BooleanValue.class, ValuesReader::readBoolean),
    BOOLEAN_ARRAY(3, BooleanArray.class, ValuesReader::readBooleanArray),
    BYTE(4, ByteValue.class, ValuesReader::readByte),
    BYTE_ARRAY(5, ByteArray.class, ValuesReader::readByteArray),
    SHORT(6, ShortValue.class, ValuesReader::readShort),
    SHORT_ARRAY(7, ShortArray.class, ValuesReader::readShortArray),
    INT(8, IntValue.class, ValuesReader::readInt),
    INT_ARRAY(9, IntArray.class, ValuesReader::readIntArray),
    LONG(10, LongValue.class, ValuesReader::readLong),
    LONG_ARRAY(11, LongArray.class, ValuesReader::readLongArray),
    FLOAT(12, FloatValue.class, ValuesReader::readFloat),
    FLOAT_ARRAY(13, FloatArray.class, ValuesReader::readFloatArray),
    DOUBLE(14, DoubleValue.class, ValuesReader::readDouble),
    DOUBLE_ARRAY(15, DoubleArray.class, ValuesReader::readDoubleArray),
    STRING(16, StringValue.class, ValuesReader::readString),
    STRING_ARRAY(17, StringArray.class, ValuesReader::readStringArray),
    CHAR(18, CharValue.class, ValuesReader::readChar),
    CHAR_ARRAY(19, CharArray.class, ValuesReader::readCharArray),
    POINT(20, PointValue.class, ValuesReader::readPoint),
    POINT_ARRAY(21, PointArray.class, ValuesReader::readPointArray),
    DURATION(22, DurationValue.class, ValuesReader::readDuration),
    DURATION_ARRAY(23, DurationArray.class, ValuesReader::readDurationArray),
    DATE(24, DateValue.class, ValuesReader::readDate),
    DATE_ARRAY(25, DateArray.class, ValuesReader::readDateArray),
    TIME(26, TimeValue.class, ValuesReader::readTime),
    TIME_ARRAY(27, TimeArray.class, ValuesReader::readTimeArray),
    DATE_TIME(28, DateTimeValue.class, ValuesReader::readDateTime),
    DATE_TIME_ARRAY(29, DateTimeArray.class, ValuesReader::readDateTimeArray),
    LOCAL_TIME(30, LocalTimeValue.class, ValuesReader::readLocalTime),
    LOCAL_TIME_ARRAY(31, LocalTimeArray.class, ValuesReader::readLocalTimeArray),
    LOCAL_DATE_TIME(32, LocalDateTimeValue.class, ValuesReader::readLocalDateTime),
    LOCAL_DATE_TIME_ARRAY(33, LocalDateTimeArray.class, ValuesReader::readLocalDateTimeArray),
    PATH(34, VirtualPathValue.class, ValuesReader::readPath),
    NODE(35, VirtualNodeValue.class, ValuesReader::readNode),
    RELATIONSHIP(36, VirtualRelationshipValue.class, ValuesReader::readRelationship),
    LIST(37, ListValue.class, ValuesReader::readList),
    MAP(38, MapValue.class, ValuesReader::readMap);

    public static final ImmutableByteObjectMap<ValuesReader> BY_ID;
    private final byte id;
    private final Class<?> valueClass;
    private final ValueReader<?> reader;

    private <T extends AnyValue> ValuesReader(byte id, Class<? extends T> valueClass, ValueReader<T> reader) {
        this.id = id;
        this.valueClass = valueClass;
        this.reader = reader;
    }

    public AnyValue read(ByteBuffer buffer) {
        return this.reader.read(buffer);
    }

    public static ValuesReader forValueClass(Class<? extends AnyValue> type) {
        for (ValuesReader valuesReader : BY_ID) {
            if (!valuesReader.valueClass.isAssignableFrom(type)) continue;
            return valuesReader;
        }
        throw new IllegalArgumentException("Unsupported value type: " + String.valueOf(type));
    }

    public static AnyValue from(ByteBuffer buffer) {
        byte type = buffer.get();
        ValuesReader reader = (ValuesReader)((Object)BY_ID.get(type));
        if (reader == null) {
            throw new IllegalArgumentException("Unsupported value type: " + type);
        }
        return reader.read(buffer);
    }

    public static String readJavaString(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.getInt()];
        buffer.get(bytes, 0, bytes.length);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static ByteValue readByte(ByteBuffer buffer) {
        return Values.byteValue((byte)buffer.get());
    }

    private static ByteArray readByteArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] values = new byte[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.get();
        }
        return Values.byteArray((byte[])values);
    }

    private static BooleanValue readBoolean(ByteBuffer buffer) {
        return Values.booleanValue((boolean)ValuesReader.readJavaBoolean(buffer));
    }

    private static BooleanArray readBooleanArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        boolean[] values = new boolean[length];
        for (int i = 0; i < length; ++i) {
            values[i] = ValuesReader.readJavaBoolean(buffer);
        }
        return Values.booleanArray((boolean[])values);
    }

    private static CharValue readChar(ByteBuffer buffer) {
        return Values.charValue((char)buffer.getChar());
    }

    private static CharArray readCharArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        char[] values = new char[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getChar();
        }
        return Values.charArray((char[])values);
    }

    private static ShortValue readShort(ByteBuffer buffer) {
        return Values.shortValue((short)buffer.getShort());
    }

    private static ShortArray readShortArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        short[] values = new short[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getShort();
        }
        return Values.shortArray((short[])values);
    }

    private static IntValue readInt(ByteBuffer buffer) {
        return Values.intValue((int)buffer.getInt());
    }

    private static IntArray readIntArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        int[] values = new int[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getInt();
        }
        return Values.intArray((int[])values);
    }

    private static LongValue readLong(ByteBuffer buffer) {
        return Values.longValue((long)buffer.getLong());
    }

    private static LongArray readLongArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        long[] values = new long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getLong();
        }
        return Values.longArray((long[])values);
    }

    private static FloatValue readFloat(ByteBuffer buffer) {
        return Values.floatValue((float)buffer.getFloat());
    }

    private static FloatArray readFloatArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        float[] values = new float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getFloat();
        }
        return Values.floatArray((float[])values);
    }

    private static DoubleValue readDouble(ByteBuffer buffer) {
        return Values.doubleValue((double)buffer.getDouble());
    }

    private static DoubleArray readDoubleArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = buffer.getDouble();
        }
        return Values.doubleArray((double[])values);
    }

    private static TextValue readString(ByteBuffer buffer) {
        return Values.stringValue((String)ValuesReader.readJavaString(buffer));
    }

    private static TextArray readStringArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = ValuesReader.readJavaString(buffer);
        }
        return Values.stringArray((String[])values);
    }

    private static PointValue readPoint(ByteBuffer buffer) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get((int)buffer.getInt());
        double[] coordinates = new double[crs.getDimension()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = buffer.getDouble();
        }
        return Values.pointValue((CoordinateReferenceSystem)crs, (double[])coordinates);
    }

    private static PointArray readPointArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        PointValue[] values = new PointValue[length];
        for (int i = 0; i < length; ++i) {
            values[i] = ValuesReader.readPoint(buffer);
        }
        return Values.pointArray((PointValue[])values);
    }

    private static DurationValue readDuration(ByteBuffer buffer) {
        long months = buffer.getLong();
        long days = buffer.getLong();
        long seconds = buffer.getLong();
        int nanos = buffer.getInt();
        return DurationValue.duration((long)months, (long)days, (long)seconds, (long)nanos);
    }

    private static DurationArray readDurationArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        DurationValue[] values = new DurationValue[length];
        for (int i = 0; i < length; ++i) {
            values[i] = ValuesReader.readDuration(buffer);
        }
        return Values.durationArray((DurationValue[])values);
    }

    private static DateValue readDate(ByteBuffer buffer) {
        return DateValue.epochDate((long)buffer.getLong());
    }

    private static DateArray readDateArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        LocalDate[] values = new LocalDate[length];
        for (int i = 0; i < length; ++i) {
            values[i] = LocalDate.ofEpochDay(buffer.getLong());
        }
        return Values.dateArray((LocalDate[])values);
    }

    private static TimeValue readTime(ByteBuffer buffer) {
        return TimeValue.time((OffsetTime)ValuesReader.readRawTime(buffer));
    }

    private static TimeArray readTimeArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        OffsetTime[] values = new OffsetTime[length];
        for (int i = 0; i < length; ++i) {
            values[i] = ValuesReader.readRawTime(buffer);
        }
        return Values.timeArray((OffsetTime[])values);
    }

    private static DateTimeValue readDateTime(ByteBuffer buffer) {
        long epocSeconds = buffer.getLong();
        int nanos = buffer.getInt();
        return DateTimeValue.datetime((long)epocSeconds, (long)nanos, (ZoneId)ValuesReader.toZoneId(buffer.getInt()));
    }

    private static DateTimeArray readDateTimeArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        ZonedDateTime[] array = new ZonedDateTime[length];
        for (int i = 0; i < length; ++i) {
            long epocSeconds = buffer.getLong();
            int nanos = buffer.getInt();
            int z = buffer.getInt();
            array[i] = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epocSeconds, nanos), ValuesReader.toZoneId(z));
        }
        return Values.dateTimeArray((ZonedDateTime[])array);
    }

    private static LocalTimeValue readLocalTime(ByteBuffer buffer) {
        return LocalTimeValue.localTime((long)buffer.getLong());
    }

    private static LocalTimeArray readLocalTimeArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        LocalTime[] array = new LocalTime[length];
        for (int i = 0; i < length; ++i) {
            array[i] = LocalTime.ofNanoOfDay(buffer.getLong());
        }
        return Values.localTimeArray((LocalTime[])array);
    }

    private static LocalDateTimeValue readLocalDateTime(ByteBuffer buffer) {
        long epochSecond = buffer.getLong();
        int nanos = buffer.getInt();
        return LocalDateTimeValue.localDateTime((long)epochSecond, (long)nanos);
    }

    private static LocalDateTimeArray readLocalDateTimeArray(ByteBuffer buffer) {
        int length = buffer.getInt();
        LocalDateTime[] array = new LocalDateTime[length];
        for (int i = 0; i < length; ++i) {
            long epochSecond = buffer.getLong();
            int nanos = buffer.getInt();
            array[i] = LocalDateTime.ofEpochSecond(epochSecond, nanos, ZoneOffset.UTC);
        }
        return Values.localDateTimeArray((LocalDateTime[])array);
    }

    private static VirtualPathValue readPath(ByteBuffer buffer) {
        boolean isDirect = ValuesReader.readJavaBoolean(buffer);
        int nodeCount = buffer.getInt();
        if (isDirect) {
            int beforePos = buffer.position();
            NodeValue[] nodes = new NodeValue[nodeCount];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = (NodeValue)ValuesReader.readNode(buffer);
            }
            RelationshipValue[] relationships = new RelationshipValue[nodeCount - 1];
            for (int i = 0; i < relationships.length; ++i) {
                relationships[i] = (RelationshipValue)ValuesReader.readRelationship(buffer);
            }
            int payloadSize = buffer.position() - beforePos;
            return VirtualValues.path((NodeValue[])nodes, (RelationshipValue[])relationships, (long)payloadSize);
        }
        long[] nodes = new long[nodeCount];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = buffer.getLong();
        }
        long[] relationships = new long[nodeCount - 1];
        for (int i = 0; i < relationships.length; ++i) {
            relationships[i] = buffer.getLong();
        }
        return VirtualValues.pathReference((long[])nodes, (long[])relationships);
    }

    private static VirtualNodeValue readNode(ByteBuffer buffer) {
        boolean isDirect = ValuesReader.readJavaBoolean(buffer);
        long nodeId = buffer.getLong();
        if (isDirect) {
            String elementId = ValuesReader.readJavaString(buffer);
            boolean isDeleted = ValuesReader.readJavaBoolean(buffer);
            TextArray labels = ValuesReader.readStringArray(buffer);
            MapValue properties = ValuesReader.readMap(buffer);
            return VirtualValues.nodeValue((long)nodeId, (String)elementId, (TextArray)labels, (MapValue)properties, (boolean)isDeleted);
        }
        return VirtualValues.node((long)nodeId);
    }

    private static VirtualRelationshipValue readRelationship(ByteBuffer buffer) {
        boolean isDirect = ValuesReader.readJavaBoolean(buffer);
        long relId = buffer.getLong();
        if (isDirect) {
            String elementId = ValuesReader.readJavaString(buffer);
            TextValue type = ValuesReader.readString(buffer);
            boolean isDeleted = ValuesReader.readJavaBoolean(buffer);
            long startId = buffer.getLong();
            String startElementId = ValuesReader.readJavaString(buffer);
            long endId = buffer.getLong();
            String endElementId = ValuesReader.readJavaString(buffer);
            MapValue properties = ValuesReader.readMap(buffer);
            return VirtualValues.relationshipValue((long)relId, (String)elementId, (VirtualNodeReference)VirtualValues.node((long)startId, (String)startElementId), (VirtualNodeReference)VirtualValues.node((long)endId, (String)endElementId), (TextValue)type, (MapValue)properties, (boolean)isDeleted);
        }
        return VirtualValues.relationship((long)relId);
    }

    private static ListValue readList(ByteBuffer buffer) {
        AnyValue[] values = new AnyValue[buffer.getInt()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ValuesReader.from(buffer);
        }
        return VirtualValues.list((AnyValue[])values);
    }

    private static MapValue readMap(ByteBuffer buffer) {
        int entryCount = buffer.getInt();
        String[] keys = new String[entryCount];
        AnyValue[] values = new AnyValue[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            keys[i] = ValuesReader.readJavaString(buffer);
            values[i] = ValuesReader.from(buffer);
        }
        return VirtualValues.map((String[])keys, (AnyValue[])values);
    }

    private static boolean readJavaBoolean(ByteBuffer buffer) {
        return buffer.get() == 1;
    }

    private static OffsetTime readRawTime(ByteBuffer buffer) {
        long nanosOfDayUTC = buffer.getLong();
        int offsetSeconds = buffer.getInt();
        return OffsetTime.ofInstant(Instant.ofEpochSecond(0L, nanosOfDayUTC), TimeUtil.zoneOffsetOfTotalSeconds((int)offsetSeconds));
    }

    private static ZoneId toZoneId(int z) {
        if ((z & 1) != 0) {
            String zoneId = TimeZones.map((short)((short)(z >> 1)));
            return ZoneId.of(zoneId);
        }
        return TimeUtil.zoneOffsetOfTotalSeconds((int)(z >> 1));
    }

    public byte id() {
        return this.id;
    }

    static {
        BY_ID = ByteObjectMaps.immutable.from(List.of(ValuesReader.values()), ValuesReader::id, (Function & Serializable)v -> v);
    }

    @FunctionalInterface
    public static interface ValueReader<T extends AnyValue> {
        public T read(ByteBuffer var1);
    }
}

