/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.collection.diffset.DiffSets;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.newapi.SchemaReadCoreSnapshot;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;

public class KernelSchemaRead
implements SchemaRead {
    private final SchemaState schemaState;
    private final IndexStatisticsStore indexStatisticsStore;
    private final StorageReader storageReader;
    private final Locks entityLocks;
    protected final TxStateHolder txStateHolder;
    private final IndexingService indexingService;
    private final AssertOpen assertOpen;
    private final AccessModeProvider accessModeProvider;
    private final SchemaReadCoreSnapshot schemaReadCoreImpl;

    public KernelSchemaRead(SchemaState schemaState, IndexStatisticsStore indexStatisticsStore, StorageReader storageReader, Locks entityLocks, TxStateHolder txStateHolder, IndexingService indexingService, AssertOpen assertOpen, AccessModeProvider accessModeProvider) {
        this.schemaState = schemaState;
        this.indexStatisticsStore = indexStatisticsStore;
        this.storageReader = storageReader;
        this.entityLocks = entityLocks;
        this.txStateHolder = txStateHolder;
        this.indexingService = indexingService;
        this.assertOpen = assertOpen;
        this.accessModeProvider = accessModeProvider;
        this.schemaReadCoreImpl = new SchemaReadCoreSnapshot((StorageSchemaReader)storageReader, txStateHolder, indexingService, indexStatisticsStore, accessModeProvider);
    }

    static void assertValidIndex(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw IndexNotFoundKernelException.indexNotFound();
        }
    }

    private void performCheckBeforeOperation() {
        this.assertOpen.assertOpen();
    }

    public IndexUsageStats indexUsageStats(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.indexUsageStats(index);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAllNonLocking() {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.constraintsGetAllNonLocking();
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.performCheckBeforeOperation();
        return this.lockConstraints(this.schemaReadCoreImpl.constraintsGetAllNonLocking());
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipTypeNonLocking(int typeId) {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.constraintsGetForRelationshipTypeNonLocking(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedRelationshipTypeLock(new long[]{typeId});
        return this.schemaReadCoreImpl.constraintsGetForRelationshipTypeNonLocking(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabelNonLocking(int labelId) {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.constraintsGetForLabelNonLocking(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedLabelLock(new long[]{labelId});
        return this.lockConstraints(this.schemaReadCoreImpl.constraintsGetForLabelNonLocking(labelId));
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.indexGetFailure(index);
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.indexGetPopulationProgress(index);
    }

    public InternalIndexState indexGetStateNonLocking(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        return this.schemaReadCoreImpl.indexGetStateNonLocking(index);
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)index);
        return this.schemaReadCoreImpl.indexGetStateNonLocking(index);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        this.performCheckBeforeOperation();
        return this.lockIndexes(this.schemaReadCoreImpl.indexesGetAll());
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedRelationshipTypeLock(new long[]{relationshipType});
        return this.lockIndexes(this.schemaReadCoreImpl.indexesGetForRelationshipType(relationshipType));
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedLabelLock(new long[]{labelId});
        return this.lockIndexes(this.schemaReadCoreImpl.indexesGetForLabel(labelId));
    }

    public IndexDescriptor index(SchemaDescriptor schema, IndexType type) {
        this.performCheckBeforeOperation();
        return this.lockIndex(this.schemaReadCoreImpl.index(schema, type));
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        this.performCheckBeforeOperation();
        return this.lockIndexes(this.schemaReadCoreImpl.index(schema));
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        this.performCheckBeforeOperation();
        return this.lockConstraint(this.schemaReadCoreImpl.constraintGetForName(name));
    }

    public IndexDescriptor indexGetForName(String name) {
        this.performCheckBeforeOperation();
        return this.lockIndex(this.schemaReadCoreImpl.indexGetForName(name));
    }

    public Iterator<IndexDescriptor> indexForSchemaNonTransactional(SchemaDescriptor schema) {
        return this.storageReader.indexGetForSchema(schema);
    }

    public IndexDescriptor indexForSchemaAndIndexTypeNonTransactional(SchemaDescriptor schema, IndexType indexType) {
        IndexDescriptor index = this.storageReader.indexGetForSchemaAndType(schema, indexType);
        return index == null ? IndexDescriptor.NO_INDEX : index;
    }

    public Iterator<IndexDescriptor> indexForSchemaNonLocking(SchemaDescriptor schema) {
        return this.schemaReadCoreImpl.index(schema);
    }

    public Iterator<IndexDescriptor> getLabelIndexesNonLocking(int labelId) {
        return this.schemaReadCoreImpl.indexesGetForLabel(labelId);
    }

    public Iterator<IndexDescriptor> getRelTypeIndexesNonLocking(int relTypeId) {
        return this.schemaReadCoreImpl.indexesGetForRelationshipType(relTypeId);
    }

    public Iterator<IndexDescriptor> indexesGetAllNonLocking() {
        return this.schemaReadCoreImpl.indexesGetAll();
    }

    private IndexDescriptor lockIndex(IndexDescriptor index) {
        if (index == null || index == IndexDescriptor.NO_INDEX) {
            return IndexDescriptor.NO_INDEX;
        }
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)index);
        if (this.indexNotExists(index)) {
            this.entityLocks.releaseSharedSchemaLock((SchemaDescriptorSupplier)index);
            return IndexDescriptor.NO_INDEX;
        }
        return index;
    }

    private Iterator<IndexDescriptor> lockIndexes(Iterator<IndexDescriptor> indexes) {
        Predicate<IndexDescriptor> exists = index -> index != IndexDescriptor.NO_INDEX;
        return Iterators.filter(exists, (Iterator)Iterators.map(this::lockIndex, indexes));
    }

    private boolean indexNotExists(IndexDescriptor index) {
        if (this.txStateHolder.hasTxStateWithChanges()) {
            DiffSets changes = this.txStateHolder.txState().indexChanges();
            return !changes.isAdded((Object)index) && (!this.storageReader.indexExists(index) || changes.isRemoved((Object)index));
        }
        return !this.storageReader.indexExists(index);
    }

    public void assertIndexExists(IndexDescriptor index) throws IndexNotFoundKernelException {
        if (this.indexNotExists(index)) {
            throw IndexNotFoundKernelException.indexNotFound((IndexDescriptor)index);
        }
    }

    private ConstraintDescriptor lockConstraint(ConstraintDescriptor constraint) {
        if (constraint == null) {
            return null;
        }
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)constraint);
        if (!this.constraintExists(constraint)) {
            this.entityLocks.releaseSharedSchemaLock((SchemaDescriptorSupplier)constraint);
            return null;
        }
        return constraint;
    }

    private Iterator<ConstraintDescriptor> lockConstraints(Iterator<ConstraintDescriptor> constraints) {
        return Iterators.filter(Objects::nonNull, (Iterator)Iterators.map(this::lockConstraint, constraints));
    }

    public boolean constraintExists(ConstraintDescriptor constraint) {
        this.performCheckBeforeOperation();
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)constraint);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            DiffSets changes = this.txStateHolder.txState().constraintsChanges();
            return changes.isAdded((Object)constraint) || this.storageReader.constraintExists(constraint) && !changes.isRemoved((Object)constraint);
        }
        return this.storageReader.constraintExists(constraint);
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)index);
        return this.indexGetOwningUniquenessConstraintIdNonLocking(index);
    }

    public Long indexGetOwningUniquenessConstraintIdNonLocking(IndexDescriptor index) {
        this.performCheckBeforeOperation();
        return this.storageReader.indexGetOwningUniquenessConstraintId(this.storageReader.indexGetForName(index.getName()));
    }

    public double indexUniqueValuesSelectivity(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        KernelSchemaRead.assertValidIndex(index);
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)index);
        this.assertIndexExists(index);
        IndexSample indexSample = this.indexStatisticsStore.indexSample(index.getId());
        long unique = indexSample.uniqueValues();
        long size = indexSample.sampleSize();
        return size == 0L ? 1.0 : (double)unique / (double)size;
    }

    public long indexSize(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        KernelSchemaRead.assertValidIndex(index);
        this.entityLocks.acquireSharedSchemaLock((SchemaDescriptorSupplier)index);
        return this.indexStatisticsStore.indexSample(index.getId()).indexSize();
    }

    public IndexSample indexSample(IndexDescriptor index) throws IndexNotFoundKernelException {
        this.performCheckBeforeOperation();
        KernelSchemaRead.assertValidIndex(index);
        return this.indexStatisticsStore.indexSample(index.getId());
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor schema) {
        this.entityLocks.acquireSharedSchemaLock(() -> schema);
        return this.getConstraintsForSchema(schema);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchemaNonLocking(SchemaDescriptor schema) {
        return this.getConstraintsForSchema(schema);
    }

    private Iterator<ConstraintDescriptor> getConstraintsForSchema(SchemaDescriptor schema) {
        this.performCheckBeforeOperation();
        Iterator constraints = this.storageReader.constraintsGetForSchema(schema);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            return this.txStateHolder.txState().constraintsChangesForSchema(schema).apply(constraints);
        }
        return constraints;
    }

    public SchemaReadCore snapshot() {
        this.performCheckBeforeOperation();
        StorageSchemaReader snapshot = this.storageReader.schemaSnapshot();
        return new SchemaReadCoreSnapshot(snapshot, this.txStateHolder, this.indexingService, this.indexStatisticsStore, this.accessModeProvider);
    }

    public <K, V> V schemaStateGetOrCreate(K key, Function<K, V> creator) {
        return (V)this.schemaState.getOrCreate(key, creator);
    }

    public void schemaStateFlush() {
        this.schemaState.clear();
    }
}

