/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.IndexReaderCache;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.DefaultIndexReadSession;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.DefaultTokenReadSession;
import org.neo4j.kernel.impl.newapi.EntityCounter;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.InternalTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.KernelSchemaRead;
import org.neo4j.kernel.impl.newapi.PartitionedNodeCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedRelationshipCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedTokenCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedTokenIndexCursorScan;
import org.neo4j.kernel.impl.newapi.PartitionedValueIndexCursorSeek;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public final class KernelRead
implements Read {
    private final StorageReader storageReader;
    private final CursorFactory cursors;
    private final IndexingService indexingService;
    private final MemoryTracker memoryTracker;
    private final IndexReaderCache<ValueIndexReader> valueIndexReaderCache;
    private final IndexReaderCache<TokenIndexReader> tokenIndexReaderCache;
    private final EntityCounter entityCounter;
    private final boolean applyAccessModeToTxState;
    private final TokenRead tokenRead;
    private final StoreCursors storageCursors;
    private final QueryContext queryContext;
    private final Locks entityLocks;
    private final TxStateHolder txStateHolder;
    private final SchemaRead schemaRead;
    private final AssertOpen assertOpen;
    private final AccessModeProvider accessModeProvider;
    private final boolean parallel;
    private final Log log;

    public KernelRead(StorageReader storageReader, TokenRead tokenRead, CursorFactory cursors, StoreCursors storageCursors, Locks entityLocks, QueryContext queryContext, TxStateHolder txStateHolder, SchemaRead schemaRead, IndexingService indexingService, MemoryTracker memoryTracker, boolean multiVersioned, AssertOpen assertOpen, AccessModeProvider accessModeProvider, boolean parallel, LogProvider logProvider) {
        this.storageReader = storageReader;
        this.tokenRead = tokenRead;
        this.cursors = cursors;
        this.storageCursors = storageCursors;
        this.entityLocks = entityLocks;
        this.queryContext = queryContext;
        this.txStateHolder = txStateHolder;
        this.schemaRead = schemaRead;
        this.indexingService = indexingService;
        this.memoryTracker = memoryTracker;
        this.valueIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newValueReader());
        this.tokenIndexReaderCache = new IndexReaderCache(index -> indexingService.getIndexProxy((IndexDescriptor)index).newTokenReader());
        this.entityCounter = new EntityCounter(multiVersioned);
        this.applyAccessModeToTxState = multiVersioned;
        this.assertOpen = assertOpen;
        this.accessModeProvider = accessModeProvider;
        this.parallel = parallel;
        this.log = logProvider.getLog(this.getClass());
    }

    public void nodeIndexSeek(QueryContext queryContext, IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Node index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.initState(this, this.txStateHolder, this.accessModeProvider);
        indexSession.reader().query((IndexProgressor.EntityValueClient)client, queryContext, queryContext.cursorContext(), constraints, query);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Node index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    public void relationshipIndexSeek(QueryContext queryContext, IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        this.validateConstraints(constraints, indexSession);
        if (indexSession.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Relationship index seek can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        EntityIndexSeekClient client = (EntityIndexSeekClient)cursor;
        client.initState(this, this.txStateHolder, this.accessModeProvider);
        indexSession.reader().query((IndexProgressor.EntityValueClient)client, queryContext, queryContext.cursorContext(), constraints, query);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Relationship index seek can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, query);
    }

    private void verifyNotParallel() {
        if (this.parallel) {
            throw new UnsupportedOperationException("Locking unique index seek not allowed during parallel execution");
        }
    }

    public long lockingNodeUniqueIndexSeek(IndexDescriptor index, NodeValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws IndexNotApplicableKernelException, IndexNotFoundKernelException, IndexBrokenKernelException {
        this.verifyNotParallel();
        this.assertIndexOnline(index);
        KernelRead.assertPredicatesMatchSchema(index, predicates);
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.getName(), (String)("Multi-token index " + String.valueOf(index) + " does not support uniqueness."));
        }
        long indexEntryId = ResourceIds.indexEntryResourceId(entityTokenIds[0], predicates);
        this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
        try (IndexReaders readers = new IndexReaders(index, this);){
            this.nodeIndexSeekWithFreshIndexReader((DefaultNodeValueIndexCursor)cursor, this.queryContext.cursorContext(), readers.createReader(), predicates);
            if (!cursor.next()) {
                this.entityLocks.releaseSharedIndexEntryLock(new long[]{indexEntryId});
                this.entityLocks.acquireExclusiveIndexEntryLock(new long[]{indexEntryId});
                this.nodeIndexSeekWithFreshIndexReader((DefaultNodeValueIndexCursor)cursor, this.queryContext.cursorContext(), readers.createReader(), predicates);
                if (cursor.next()) {
                    this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
                    this.entityLocks.releaseExclusiveIndexEntryLock(new long[]{indexEntryId});
                    long l = cursor.nodeReference();
                    return l;
                }
                long l = -1L;
                return l;
            }
            long l = cursor.nodeReference();
            return l;
        }
    }

    public long lockingRelationshipUniqueIndexSeek(IndexDescriptor index, RelationshipValueIndexCursor cursor, PropertyIndexQuery.ExactPredicate ... predicates) throws KernelException {
        this.verifyNotParallel();
        this.assertIndexOnline(index);
        KernelRead.assertPredicatesMatchSchema(index, predicates);
        int[] entityTokenIds = index.schema().getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.getName(), (String)("Multi-token index " + String.valueOf(index) + " does not support uniqueness."));
        }
        long indexEntryId = ResourceIds.indexEntryResourceId(entityTokenIds[0], predicates);
        this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
        try (IndexReaders readers = new IndexReaders(index, this);){
            EntityIndexSeekClient indexCursor = (EntityIndexSeekClient)cursor;
            this.relationshipIndexSeekWithFreshIndexReader(indexCursor, this.queryContext.cursorContext(), readers.createReader(), predicates);
            if (!cursor.next()) {
                this.entityLocks.releaseSharedIndexEntryLock(new long[]{indexEntryId});
                this.entityLocks.acquireExclusiveIndexEntryLock(new long[]{indexEntryId});
                this.relationshipIndexSeekWithFreshIndexReader(indexCursor, this.queryContext.cursorContext(), readers.createReader(), predicates);
                if (cursor.next()) {
                    this.entityLocks.acquireSharedIndexEntryLock(new long[]{indexEntryId});
                    this.entityLocks.releaseExclusiveIndexEntryLock(new long[]{indexEntryId});
                    long l = cursor.relationshipReference();
                    return l;
                }
                long l = -1L;
                return l;
            }
            long l = cursor.relationshipReference();
            return l;
        }
    }

    public void nodeIndexSeekWithFreshIndexReader(EntityIndexSeekClient cursor, CursorContext cursorContext, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.initState(this, this.txStateHolder, this.accessModeProvider);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, this.queryContext, cursorContext, IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public void relationshipIndexSeekWithFreshIndexReader(EntityIndexSeekClient cursor, CursorContext cursorContext, ValueIndexReader indexReader, PropertyIndexQuery.ExactPredicate ... query) throws IndexNotApplicableKernelException {
        cursor.initState(this, this.txStateHolder, this.accessModeProvider);
        indexReader.query((IndexProgressor.EntityValueClient)cursor, this.queryContext, cursorContext, IndexQueryConstraints.unconstrained(), (PropertyIndexQuery[])query);
    }

    public void nodeIndexScan(IndexReadSession index, NodeValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Node index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<NodeValueIndexCursor> nodeIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Node index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    public void relationshipIndexScan(IndexReadSession index, RelationshipValueIndexCursor cursor, IndexQueryConstraints constraints) throws KernelException {
        this.performCheckBeforeOperation();
        DefaultIndexReadSession indexSession = (DefaultIndexReadSession)index;
        if (indexSession.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Relationship index scan can not be performed on index: " + index.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        this.scanIndex(indexSession, (EntityIndexSeekClient)cursor, constraints);
    }

    public PartitionedScan<RelationshipValueIndexCursor> relationshipIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (descriptor.schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("Relationship index scan can not be performed on index: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.propertyIndexScan(index, desiredNumberOfPartitions, queryContext);
    }

    private void scanIndex(DefaultIndexReadSession indexSession, EntityIndexSeekClient indexSeekClient, IndexQueryConstraints constraints) throws KernelException {
        indexSeekClient.initState(this, this.txStateHolder, this.accessModeProvider);
        indexSession.reader().query((IndexProgressor.EntityValueClient)indexSeekClient, this.queryContext, this.queryContext.cursorContext(), constraints, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    public PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public PartitionedScan<NodeLabelIndexCursor> nodeLabelScan(TokenReadSession session, PartitionedScan<NodeLabelIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public List<PartitionedScan<NodeLabelIndexCursor>> nodeLabelScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public void nodeLabelScan(TokenReadSession session, NodeLabelIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.NODE) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Node label index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        DefaultNodeLabelIndexCursor indexCursor = (DefaultNodeLabelIndexCursor)cursor;
        indexCursor.initState(this, this.txStateHolder, this.accessModeProvider);
        tokenSession.reader().query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public void allNodesScan(NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).scan(this, this.txStateHolder, this.accessModeProvider);
    }

    public void singleNode(long reference, NodeCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultNodeCursor)cursor).single(reference, this, this.txStateHolder, this.accessModeProvider);
    }

    public PartitionedScan<NodeCursor> allNodesScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.nodesGetCount(cursorContext);
        return new PartitionedNodeCursorScan(this.storageReader.allNodeScan(), desiredNumberOfPartitions, totalCount);
    }

    public PartitionedScan<RelationshipScanCursor> allRelationshipsScan(int desiredNumberOfPartitions, CursorContext cursorContext) {
        this.performCheckBeforeOperation();
        long totalCount = this.storageReader.relationshipsGetCount(cursorContext);
        return new PartitionedRelationshipCursorScan(this.storageReader.allRelationshipScan(), desiredNumberOfPartitions, totalCount);
    }

    public void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, this, this.txStateHolder, this.accessModeProvider);
    }

    public void singleRelationship(long reference, long sourceNodeReference, int type, long targetNodeReference, RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).single(reference, sourceNodeReference, type, targetNodeReference, this, this.txStateHolder, this.accessModeProvider);
    }

    public void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.performCheckBeforeOperation();
        ((DefaultRelationshipScanCursor)cursor).scan(this, this.txStateHolder, this.accessModeProvider);
    }

    public PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, query);
    }

    public PartitionedScan<RelationshipTypeIndexCursor> relationshipTypeScan(TokenReadSession session, PartitionedScan<RelationshipTypeIndexCursor> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, leadingPartitionScan, query);
    }

    public List<PartitionedScan<RelationshipTypeIndexCursor>> relationshipTypeScans(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        return this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries);
    }

    public void relationshipTypeScan(TokenReadSession session, RelationshipTypeIndexCursor cursor, IndexQueryConstraints constraints, TokenPredicate query, CursorContext cursorContext) throws KernelException {
        this.performCheckBeforeOperation();
        if (session.reference().schema().entityType() != EntityType.RELATIONSHIP) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)session.reference().userDescription((TokenNameLookup)this.tokenRead), (String)("Relationship type index scan can not be performed on index: " + session.reference().userDescription((TokenNameLookup)this.tokenRead)));
        }
        DefaultTokenReadSession tokenSession = (DefaultTokenReadSession)session;
        InternalTokenIndexCursor indexCursor = (InternalTokenIndexCursor)cursor;
        indexCursor.initState(this, this.txStateHolder, this.accessModeProvider);
        tokenSession.reader().query((IndexProgressor.EntityTokenClient)indexCursor, constraints, query, cursorContext);
    }

    public void relationships(long nodeReference, long reference, RelationshipSelection selection, RelationshipTraversalCursor cursor) {
        ((DefaultRelationshipTraversalCursor)cursor).init(nodeReference, reference, selection, (Read)this, this.txStateHolder, this.accessModeProvider);
    }

    public void nodeProperties(long nodeReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initNode(nodeReference, reference, selection, this, this.txStateHolder, this.accessModeProvider);
    }

    public void relationshipProperties(long relationshipReference, Reference reference, PropertySelection selection, PropertyCursor cursor) {
        ((DefaultPropertyCursor)cursor).initRelationship(relationshipReference, reference, selection, this, this.txStateHolder, this.accessModeProvider);
    }

    private void validateConstraints(IndexQueryConstraints constraints, DefaultIndexReadSession indexSession) {
        if (constraints.needsValues() && !indexSession.reference().getCapability().supportsReturningValues()) {
            throw new UnsupportedOperationException(String.format("%s index has no value capability", indexSession.reference().getIndexType()));
        }
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexScan(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        return this.propertyIndexSeek(index, desiredNumberOfPartitions, queryContext, new PropertyIndexQuery[]{PropertyIndexQuery.allEntries()});
    }

    private <C extends Cursor> PartitionedScan<C> propertyIndexSeek(IndexReadSession index, int desiredNumberOfPartitions, QueryContext queryContext, PropertyIndexQuery ... query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = index.reference();
        if (!descriptor.getCapability().supportPartitionedScan((IndexQuery[])query)) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)index.reference().getName(), (String)("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        if (this.txStateHolder.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultIndexReadSession session = (DefaultIndexReadSession)index;
        PartitionedValueSeek valueSeek = session.reader().valueSeek(desiredNumberOfPartitions, queryContext, query);
        return new PartitionedValueIndexCursorSeek(descriptor, valueSeek, query);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)descriptor.userDescription((TokenNameLookup)this.tokenRead), (String)("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        if (this.txStateHolder.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenScan tokenScan = defaultSession.reader().entityTokenScan(desiredNumberOfPartitions, cursorContext, query);
        return new PartitionedTokenIndexCursorScan(query, tokenScan);
    }

    private <C extends Cursor> PartitionedScan<C> tokenIndexScan(TokenReadSession session, PartitionedScan<C> leadingPartitionScan, TokenPredicate query) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        IndexDescriptor descriptor = session.reference();
        if (!descriptor.getCapability().supportPartitionedScan(new IndexQuery[]{query})) {
            throw IndexNotApplicableKernelException.indexNotApplicable((Log)this.log, (String)descriptor.userDescription((TokenNameLookup)this.tokenRead), (String)("This index does not support partitioned scan for this query: " + descriptor.userDescription((TokenNameLookup)this.tokenRead)));
        }
        if (this.txStateHolder.hasTxStateWithChanges()) {
            throw new IllegalStateException("Transaction contains changes; PartitionScan is only valid in Read-Only transactions.");
        }
        DefaultTokenReadSession defaultSession = (DefaultTokenReadSession)session;
        PartitionedTokenCursorScan leadingTokenIndexCursorScan = (PartitionedTokenCursorScan)leadingPartitionScan;
        PartitionedTokenScan tokenScan = defaultSession.reader().entityTokenScan(leadingTokenIndexCursorScan.getTokenScan(), query);
        return new PartitionedTokenIndexCursorScan(query, tokenScan);
    }

    private <C extends Cursor> List<PartitionedScan<C>> tokenIndexScan(TokenReadSession session, int desiredNumberOfPartitions, CursorContext cursorContext, TokenPredicate ... queries) throws IndexNotApplicableKernelException {
        this.performCheckBeforeOperation();
        Preconditions.requireNonEmpty((Object[])queries);
        ArrayList<PartitionedScan<C>> scans = new ArrayList<PartitionedScan<C>>(queries.length);
        PartitionedScan<C> leadingPartitionScan = this.tokenIndexScan(session, desiredNumberOfPartitions, cursorContext, queries[0]);
        scans.add(leadingPartitionScan);
        for (int i = 1; i < queries.length; ++i) {
            scans.add(this.tokenIndexScan(session, leadingPartitionScan, queries[i]));
        }
        return scans;
    }

    public boolean nodeExists(long reference) {
        this.performCheckBeforeOperation();
        if (this.txStateHolder.hasTxStateWithChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            if (txState.nodeIsDeletedInThisBatch(reference)) {
                return false;
            }
            if (txState.nodeIsAddedInThisBatch(reference)) {
                return true;
            }
        }
        boolean existsInNodeStore = this.storageReader.nodeExists(reference, this.storageCursors);
        if (this.getAccessMode().allowsTraverseAllLabels()) {
            return existsInNodeStore;
        }
        if (!existsInNodeStore) {
            return false;
        }
        try (NodeCursor node = this.cursors.allocateNodeCursor(this.queryContext.cursorContext(), this.memoryTracker);){
            this.singleNode(reference, node);
            boolean bl = node.next();
            return bl;
        }
    }

    public boolean nodeDeletedInTransaction(long node) {
        this.performCheckBeforeOperation();
        return this.txStateHolder.hasTxStateWithChanges() && this.txStateHolder.txState().nodeIsDeletedInThisBatch(node);
    }

    public boolean relationshipDeletedInTransaction(long relationship) {
        this.performCheckBeforeOperation();
        return this.txStateHolder.hasTxStateWithChanges() && this.txStateHolder.txState().relationshipIsDeletedInThisBatch(relationship);
    }

    public Value nodePropertyChangeInBatchOrNull(long node, int propertyKeyId) {
        this.performCheckBeforeOperation();
        if (this.txStateHolder.hasTxStateWithChanges()) {
            if (this.applyAccessModeToTxState) {
                try (NodeCursor nodeCursor = this.cursors.allocateNodeCursor(this.queryContext.cursorContext(), this.memoryTracker);){
                    Value value;
                    block14: {
                        this.singleNode(node, nodeCursor);
                        nodeCursor.next();
                        PropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(this.queryContext.cursorContext(), this.memoryTracker);
                        try {
                            nodeCursor.properties(propertyCursor, PropertySelection.selection((int)propertyKeyId));
                            Value value2 = value = propertyCursor.allowed(propertyKeyId) ? this.txStateHolder.txState().getNodeState(node).propertyValue(propertyKeyId) : null;
                            if (propertyCursor == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (propertyCursor != null) {
                                try {
                                    propertyCursor.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        propertyCursor.close();
                    }
                    return value;
                }
            }
            return this.txStateHolder.txState().getNodeState(node).propertyValue(propertyKeyId);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value relationshipPropertyChangeInBatchOrNull(long relationship, int propertyKeyId) {
        this.performCheckBeforeOperation();
        if (!this.txStateHolder.hasTxStateWithChanges()) return null;
        RelationshipState relationshipState = this.txStateHolder.txState().getRelationshipState(relationship);
        if (this.applyAccessModeToTxState) {
            if (!relationshipState.hasPropertyChanges()) return null;
            if (!this.getAccessMode().allowsReadRelationshipProperty(() -> ((RelationshipState)relationshipState).getType(), propertyKeyId)) return null;
        }
        Value value = relationshipState.propertyValue(propertyKeyId);
        return value;
    }

    public long countsForNode(int labelId) {
        return this.entityCounter.countsForNode(labelId, this.getAccessMode(), this.storageReader, this.cursors, this.queryContext.cursorContext(), this.memoryTracker, this, this.storageCursors, this.txStateHolder);
    }

    public List<Integer> mostCommonLabelGivenRelationshipType(int type) {
        return this.entityCounter.mostCommonLabelGivenRelationshipType(type, this.storageReader, this.queryContext.cursorContext());
    }

    public long estimateCountsForNode(int labelId) {
        return this.storageReader.estimateCountsForNode(labelId, this.queryContext.cursorContext());
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        return this.entityCounter.countsForRelationship(startLabelId, typeId, endLabelId, this.getAccessMode(), this.storageReader, this.cursors, this, this.queryContext.cursorContext(), this.memoryTracker, this.storageCursors, this.schemaRead, this.txStateHolder);
    }

    public long estimateCountsForRelationships(int startLabelId, int typeId, int endLabelId) {
        return this.storageReader.estimateCountsForRelationship(startLabelId, typeId, endLabelId, this.queryContext.cursorContext());
    }

    public boolean relationshipExists(long reference) {
        this.performCheckBeforeOperation();
        if (this.txStateHolder.hasTxStateWithChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            if (txState.relationshipIsDeletedInThisBatch(reference)) {
                return false;
            }
            if (txState.relationshipIsAddedInThisBatch(reference)) {
                return true;
            }
        }
        boolean existsInRelStore = this.storageReader.relationshipExists(reference, this.storageCursors);
        if (this.getAccessMode().allowsTraverseAllRelTypes()) {
            return existsInRelStore;
        }
        if (!existsInRelStore) {
            return false;
        }
        try (DefaultRelationshipScanCursor rels = (DefaultRelationshipScanCursor)this.cursors.allocateRelationshipScanCursor(this.queryContext.cursorContext(), this.memoryTracker);){
            this.singleRelationship(reference, rels);
            boolean bl = rels.next();
            return bl;
        }
    }

    public ValueIndexReader newValueIndexReader(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).newValueReader();
    }

    private void assertIndexOnline(IndexDescriptor index) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.schemaRead.indexGetState(index) == InternalIndexState.ONLINE) {
            return;
        }
        throw IndexBrokenKernelException.indexBroken(index.getName(), this.schemaRead.indexGetFailure(index));
    }

    private static void assertPredicatesMatchSchema(IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] predicates) throws IndexNotApplicableKernelException {
        int[] propertyIds = index.schema().getPropertyIds();
        if (propertyIds.length != predicates.length) {
            throw new IndexNotApplicableKernelException(String.format("The index specifies %d properties, but only %d lookup predicates were given.", propertyIds.length, predicates.length));
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].propertyKeyId() == propertyIds[i]) continue;
            throw new IndexNotApplicableKernelException(String.format("The index has the property id %d in position %d, but the lookup property id was %d.", propertyIds[i], i, predicates[i].propertyKeyId()));
        }
    }

    private void performCheckBeforeOperation() {
        this.assertOpen.assertOpen();
    }

    private AccessMode getAccessMode() {
        return this.accessModeProvider.getAccessMode();
    }

    public TokenIndexReader newTokenIndexReader(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).newTokenReader();
    }

    public IndexReadSession indexReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return new DefaultIndexReadSession(this.valueIndexReaderCache.getOrCreate(index), index);
    }

    public TokenReadSession tokenReadSession(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return new DefaultTokenReadSession(this.tokenIndexReaderCache.getOrCreate(index), index);
    }

    public long nodesGetCount() {
        return this.countsForNode(-1);
    }

    public long relationshipsGetCount() {
        return this.countsForRelationship(-1, -1, -1);
    }

    public boolean transactionStateHasChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }

    public void release() {
        this.valueIndexReaderCache.close();
        this.tokenIndexReaderCache.close();
    }
}

