/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.TraceablePropertyCursor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class InternalCursorFactory {
    protected final StorageReader storageReader;
    protected final StoreCursors storeCursors;
    protected final CursorContext cursorContext;
    protected final MemoryTracker memoryTracker;
    protected final boolean applyAccessModeToTxState;

    protected InternalCursorFactory(StorageReader storageReader, StoreCursors storeCursors, CursorContext cursorContext, MemoryTracker memoryTracker, boolean applyAccessModeToTxState) {
        this.storageReader = storageReader;
        this.storeCursors = storeCursors;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    protected StorageNodeCursor allocateStorageNodeCursor() {
        return this.storageReader.allocateNodeCursor(this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    StorageRelationshipTraversalCursor allocateStorageRelationshipTraversalCursor() {
        return this.storageReader.allocateRelationshipTraversalCursor(this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    StoragePropertyCursor allocateStoragePropertyCursor() {
        return this.storageReader.allocatePropertyCursor(this.cursorContext, this.storeCursors, this.memoryTracker);
    }

    public DefaultNodeCursor allocateNodeCursor() {
        return new DefaultNodeCursor(c -> {}, this.allocateStorageNodeCursor(), this, this.applyAccessModeToTxState);
    }

    protected DefaultNodeCursor allocateFullAccessNodeCursor() {
        return new FullAccessNodeCursor(c -> {}, this.storageReader.allocateNodeCursor(this.cursorContext, this.storeCursors, this.memoryTracker));
    }

    protected DefaultRelationshipScanCursor allocateFullAccessRelationshipScanCursor() {
        return new FullAccessRelationshipScanCursor(c -> {}, this.storageReader.allocateRelationshipScanCursor(this.cursorContext, this.storeCursors, this.memoryTracker));
    }

    protected TraceablePropertyCursor allocatePropertyCursor() {
        return new DefaultPropertyCursor(c -> {}, this.storageReader.allocatePropertyCursor(this.cursorContext, this.storeCursors, this.memoryTracker), this, this.applyAccessModeToTxState);
    }
}

