/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.TraceablePropertyCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

class DefaultRelationshipValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultRelationshipValueIndexCursor>
implements RelationshipValueIndexCursor {
    private final InternalCursorFactory internalCursors;
    private final DefaultRelationshipScanCursor relationshipScanCursor;
    private TraceablePropertyCursor securityPropertyCursor;
    private int[] propertyIds;

    DefaultRelationshipValueIndexCursor(CursorPool<DefaultRelationshipValueIndexCursor> pool, DefaultRelationshipScanCursor relationshipScanCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool, applyAccessModeToTxState);
        this.relationshipScanCursor = relationshipScanCursor;
        this.internalCursors = internalCursors;
    }

    public void source(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.sourceNodeReference(), cursor);
    }

    public void target(NodeCursor cursor) {
        this.checkReadFromStore();
        this.read.singleNode(this.relationshipScanCursor.targetNodeReference(), cursor);
    }

    public int type() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.type();
    }

    public long relationshipReference() {
        return this.entityReference();
    }

    public long sourceNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.sourceNodeReference();
    }

    public long targetNodeReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.targetNodeReference();
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.checkReadFromStore();
        this.relationshipScanCursor.properties(cursor, selection);
    }

    public Reference propertiesReference() {
        this.checkReadFromStore();
        return this.relationshipScanCursor.propertiesReference();
    }

    public boolean readFromStore() {
        if (this.relationshipScanCursor.relationshipReference() == this.entity) {
            return true;
        }
        this.relationshipScanCursor.single(this.entity, this.read, this.txStateHolder, this.accessModeProvider);
        return this.relationshipScanCursor.next();
    }

    private void checkReadFromStore() {
        if (this.relationshipScanCursor.relationshipReference() != this.entity) {
            throw new IllegalStateException("Relationship hasn't been read from store");
        }
    }

    @Override
    protected boolean doStoreValuePassesQueryFilter(long reference, PropertySelection propertySelection, PropertyIndexQuery[] query) {
        this.read.singleRelationship(reference, (RelationshipScanCursor)this.relationshipScanCursor);
        if (this.relationshipScanCursor.next()) {
            if (this.securityPropertyCursor == null) {
                this.securityPropertyCursor = this.internalCursors.allocatePropertyCursor();
            }
            this.relationshipScanCursor.properties(this.securityPropertyCursor, propertySelection);
            return CursorPredicates.propertiesMatch(this.securityPropertyCursor, query);
        }
        return false;
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor) {
        this.propertyIds = descriptor.schema().getPropertyIds();
        AccessMode accessMode = this.accessModeProvider.getAccessMode();
        for (int relType : descriptor.schema().getEntityTokenIds()) {
            if (accessMode.allowsTraverseRelType(relType)) continue;
            return false;
        }
        if (!accessMode.allowsTraverseAllLabels()) {
            return false;
        }
        for (int propId : this.propertyIds) {
            for (int relType : descriptor.schema().getEntityTokenIds()) {
                if (accessMode.allowsReadRelationshipProperty(() -> relType, propId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected LongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedRelationships().getRemoved(), (LongIterable)removedFromIndex).asUnmodifiable();
    }

    @Override
    protected final boolean canAccessEntityAndProperties(long reference) {
        this.readEntity(read -> read.singleRelationship(reference, (RelationshipScanCursor)this.relationshipScanCursor));
        if (!this.relationshipScanCursor.next()) {
            return false;
        }
        int relType = this.relationshipScanCursor.type();
        for (int prop : this.propertyIds) {
            if (this.accessModeProvider.getAccessMode().allowsReadRelationshipProperty(() -> relType, prop)) continue;
            return false;
        }
        return true;
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onRelationship(entity);
    }

    @Override
    String implementationName() {
        return "RelationshipValueIndexCursor";
    }

    @Override
    public void release() {
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.close();
            this.relationshipScanCursor.release();
        }
        if (this.securityPropertyCursor != null) {
            this.securityPropertyCursor.close();
            this.securityPropertyCursor.release();
            this.securityPropertyCursor = null;
        }
    }
}

