/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.PhysicalToLogicalTokenChanges;
import org.neo4j.kernel.impl.index.schema.TokenIndexIdLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;

class TokenIndexUpdater
implements IndexUpdater {
    private static final ValueMerger<TokenScanKey, TokenScanValue> ADD_MERGER = (existingKey, newKey, existingValue, newValue) -> {
        existingValue.add((TokenScanValue)newValue);
        return ValueMerger.MergeResult.MERGED;
    };
    private static final ValueMerger<TokenScanKey, TokenScanValue> REMOVE_MERGER = (existingKey, newKey, existingValue, newValue) -> {
        existingValue.remove((TokenScanValue)newValue);
        return existingValue.isEmpty() ? ValueMerger.MergeResult.REMOVED : ValueMerger.MergeResult.MERGED;
    };
    private Writer<TokenScanKey, TokenScanValue> writer;
    private final TokenScanKey key = new TokenScanKey();
    private final TokenScanValue value = new TokenScanValue();
    private final PhysicalToLogicalTokenChanges.LogicalTokenUpdates[] pendingUpdates;
    private final TokenIndexIdLayout idLayout;
    private int pendingUpdatesCursor;
    private boolean addition;
    private int lowestTokenId;
    private boolean closed = true;
    private boolean parallel;
    private CursorContext cursorContext;
    private CursorContext writerCursorContext;
    private long lastVersion;

    TokenIndexUpdater(int batchSize, TokenIndexIdLayout idLayout) {
        this.pendingUpdates = new PhysicalToLogicalTokenChanges.LogicalTokenUpdates[batchSize];
        this.idLayout = idLayout;
    }

    TokenIndexUpdater initialize(TokenWriterFactory writerFactory, boolean parallel, CursorContext cursorContext) throws IOException {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.cursorContext = cursorContext;
        this.writerCursorContext = cursorContext.createRelatedContext("TOKEN_INDEX_UPDATER_APPLY");
        this.writer = writerFactory.create(this.writerCursorContext);
        this.parallel = parallel;
        this.lastVersion = cursorContext.getVersionContext().committingTransactionId();
        this.pendingUpdatesCursor = 0;
        this.addition = false;
        this.lowestTokenId = Integer.MAX_VALUE;
        this.closed = false;
        return this;
    }

    public void process(IndexEntryUpdate update) throws IndexEntryConflictException {
        this.assertOpen();
        long committingTransactionId = this.cursorContext.getVersionContext().committingTransactionId();
        if (this.pendingUpdatesCursor == this.pendingUpdates.length || this.lastVersion != committingTransactionId) {
            this.flushPendingChanges(this.lastVersion);
        }
        this.lastVersion = committingTransactionId;
        TokenIndexEntryUpdate tokenUpdate = this.asTokenUpdate(update);
        PhysicalToLogicalTokenChanges.LogicalTokenUpdates logicalTokenUpdate = PhysicalToLogicalTokenChanges.convertToAdditionsAndRemovals(tokenUpdate);
        this.pendingUpdates[this.pendingUpdatesCursor++] = logicalTokenUpdate;
        this.checkNextTokenId(tokenUpdate.beforeValues());
        this.checkNextTokenId(tokenUpdate.values());
    }

    public void yield() {
        this.writer.yield();
    }

    private void checkNextTokenId(int[] tokens) {
        if (tokens.length > 0 && tokens[0] != -1) {
            this.lowestTokenId = Math.min(this.lowestTokenId, tokens[0]);
        }
    }

    private void flushPendingChanges(long lastVersion) {
        FastList changes;
        if (this.pendingUpdatesCursor == 0) {
            return;
        }
        if (lastVersion >= 1L) {
            this.writerCursorContext.getVersionContext().initWrite(lastVersion);
        }
        Arrays.sort(this.pendingUpdates, 0, this.pendingUpdatesCursor);
        int currentTokenId = this.lowestTokenId;
        this.value.clear();
        this.key.clear();
        Object object = changes = this.parallel ? FastList.newList() : null;
        while (currentTokenId != Integer.MAX_VALUE) {
            int nextTokenId = Integer.MAX_VALUE;
            for (int i = 0; i < this.pendingUpdatesCursor; ++i) {
                PhysicalToLogicalTokenChanges.LogicalTokenUpdates update = this.pendingUpdates[i];
                long entityId = update.entityId();
                nextTokenId = this.extractChange(update.additions(), currentTokenId, entityId, nextTokenId, true, (List<Change>)changes);
                nextTokenId = this.extractChange(update.removals(), currentTokenId, entityId, nextTokenId, false, (List<Change>)changes);
            }
            currentTokenId = nextTokenId;
        }
        this.flushPendingRange((List<Change>)changes);
        this.pendingUpdatesCursor = 0;
        if (changes != null) {
            for (Change change : changes) {
                this.writeChange(change.key, change.value, change.addition);
            }
            this.writer.yield();
        }
    }

    private void writeChange(TokenScanKey key, TokenScanValue value, boolean addition) {
        if (addition) {
            this.writer.merge((Object)key, (Object)value, ADD_MERGER);
        } else {
            this.writer.mergeIfExists((Object)key, (Object)value, REMOVE_MERGER);
        }
    }

    private int extractChange(int[] tokens, int currentTokenId, long entityId, int nextTokenId, boolean addition, List<Change> changes) {
        int tokenId;
        int foundNextTokenId = nextTokenId;
        for (int li = 0; li < tokens.length && (tokenId = tokens[li]) != -1; ++li) {
            if (tokenId == currentTokenId) {
                this.change(currentTokenId, entityId, addition, changes);
                if (li + 1 >= tokens.length || tokens[li + 1] == -1) break;
                int nextTokenCandidate = tokens[li + 1];
                if (nextTokenCandidate < currentTokenId) {
                    throw new IllegalArgumentException("The entity token contained unsorted tokens ids " + Arrays.toString(tokens));
                }
                if (nextTokenCandidate <= currentTokenId) break;
                foundNextTokenId = Math.min(foundNextTokenId, nextTokenCandidate);
                break;
            }
            if (tokenId <= currentTokenId) continue;
            foundNextTokenId = Math.min(foundNextTokenId, tokenId);
        }
        return foundNextTokenId;
    }

    private void change(int tokenId, long entityId, boolean add, List<Change> changes) {
        long idRange = this.idLayout.rangeOf(entityId);
        if (tokenId != this.key.tokenId || idRange != this.key.idRange || this.addition != add) {
            this.flushPendingRange(changes);
            this.key.tokenId = tokenId;
            this.key.idRange = idRange;
            this.addition = add;
        }
        int offset = this.idLayout.idWithinRange(entityId);
        this.value.set(offset);
    }

    private void flushPendingRange(List<Change> changes) {
        if (this.value.bits != 0L) {
            if (this.parallel) {
                changes.add(new Change(new TokenScanKey(this.key.tokenId, this.key.idRange), new TokenScanValue(this.value.bits), this.addition));
            } else {
                this.writeChange(this.key, this.value, this.addition);
            }
            this.value.clear();
        }
    }

    public void close() {
        try {
            this.flushPendingChanges(this.lastVersion);
            this.closed = true;
        }
        catch (Throwable throwable) {
            this.closed = true;
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.writer});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.writer});
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    @FunctionalInterface
    static interface TokenWriterFactory {
        public Writer<TokenScanKey, TokenScanValue> create(CursorContext var1) throws IOException;
    }

    record Change(TokenScanKey key, TokenScanValue value, boolean addition) {
    }
}

