/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class GraphDatabaseTransactions
implements GraphDatabaseAPI {
    private final Config config;

    protected GraphDatabaseTransactions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.executeTransactionally(query, Collections.emptyMap(), ResultTransformer.EMPTY_TRANSFORMER);
    }

    public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.executeTransactionally(query, parameters, ResultTransformer.EMPTY_TRANSFORMER);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
        return this.executeTransactionally(query, parameters, resultTransformer, this.defaultTransactionTimeout());
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
        Object transformedResult;
        try (InternalTransaction internalTransaction = this.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, timeout.toMillis(), TimeUnit.MILLISECONDS);){
            try (Result result = internalTransaction.execute(query, parameters);){
                transformedResult = resultTransformer.apply((Object)result);
            }
            internalTransaction.commit();
        }
        return (T)transformedResult;
    }

    public Transaction beginTx() {
        return this.beginTransaction();
    }

    public Transaction beginTx(long timeout, TimeUnit unit) {
        return this.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED, ClientConnectionInfo.EMBEDDED_CONNECTION, timeout, unit);
    }

    protected InternalTransaction beginTransaction() {
        return this.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.beginTransaction(type, loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION);
    }

    @Override
    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo) {
        return this.beginTransaction(type, loginContext, clientInfo, this.defaultTransactionTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public abstract InternalTransaction beginTransaction(KernelTransaction.Type var1, LoginContext var2, ClientConnectionInfo var3, long var4, TimeUnit var6);

    protected Duration defaultTransactionTimeout() {
        return (Duration)this.config.get(GraphDatabaseSettings.transaction_timeout);
    }
}

