/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public abstract class SystemDatabaseReferenceRepository
implements DatabaseReferenceRepository {
    private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, true);

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedCatalogEntry catalogEntry) {
        if (catalogEntry.compositeDb().isEmpty() && catalogEntry.databaseAlias().equals("system")) {
            return Optional.of(SYSTEM_DATABASE_REFERENCE);
        }
        return this.execute(model -> model.getDatabaseRefByAlias(catalogEntry));
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
        return this.getByAlias(new NormalizedCatalogEntry(this.normalizeCatalogName(databaseAlias.name())));
    }

    @Override
    public Optional<DatabaseReference> getByUuid(UUID databaseId) {
        if (Objects.equals(SYSTEM_DATABASE_REFERENCE.id(), databaseId)) {
            return Optional.of(SYSTEM_DATABASE_REFERENCE);
        }
        return this.execute(model -> model.getDatabaseIdByUUID(databaseId).flatMap(id -> model.getDatabaseRefByAlias(new NormalizedCatalogEntry(id.name()))));
    }

    private String normalizeCatalogName(String databaseAlias) {
        if (databaseAlias.matches("`.*\\..*`")) {
            String unquoted = databaseAlias.substring(1, databaseAlias.length() - 1);
            return unquoted.replace("``", "`");
        }
        return databaseAlias;
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllDatabaseReferences);
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences() {
        return this.execute(TopologyGraphDbmsModel::getAllCompositeDatabaseReferences);
    }

    protected abstract <T> T execute(Function<TopologyGraphDbmsModel, T> var1);
}

