/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class MapCachingDatabaseReferenceRepository
implements DatabaseReferenceRepository.Caching {
    private DatabaseReferenceRepository delegate;
    private volatile Map<NormalizedDatabaseName, DatabaseReference> databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
    private volatile Map<NormalizedCatalogEntry, DatabaseReference> databaseRefsByCatalogEntry = new ConcurrentHashMap<NormalizedCatalogEntry, DatabaseReference>();
    private volatile Map<UUID, DatabaseReference> databaseRefsByUUID = new ConcurrentHashMap<UUID, DatabaseReference>();

    public MapCachingDatabaseReferenceRepository(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    public MapCachingDatabaseReferenceRepository() {
        this(null);
    }

    public void setDelegate(DatabaseReferenceRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedCatalogEntry catalogEntry) {
        Optional<DatabaseReference> databaseRef = Optional.ofNullable(this.databaseRefsByCatalogEntry.computeIfAbsent(catalogEntry, this::lookupReferenceOnDelegate));
        databaseRef.ifPresent(databaseReference -> this.databaseRefsByUUID.putIfAbsent(databaseReference.id(), (DatabaseReference)databaseReference));
        return databaseRef;
    }

    @Override
    public Optional<DatabaseReference> getByAlias(NormalizedDatabaseName databaseAlias) {
        Optional<DatabaseReference> databaseRef = Optional.ofNullable(this.databaseRefsByName.computeIfAbsent(databaseAlias, this::lookupReferenceOnDelegate));
        databaseRef.ifPresent(databaseReference -> {
            this.databaseRefsByCatalogEntry.putIfAbsent(databaseReference.catalogEntry(), (DatabaseReference)databaseReference);
            this.databaseRefsByUUID.putIfAbsent(databaseReference.id(), (DatabaseReference)databaseReference);
        });
        return databaseRef;
    }

    @Override
    public Optional<DatabaseReference> getByUuid(UUID uuid) {
        Optional<DatabaseReference> databaseRef = Optional.ofNullable(this.databaseRefsByUUID.computeIfAbsent(uuid, this::lookupReferenceByUuidOnDelegate));
        databaseRef.ifPresent(databaseReference -> {
            this.databaseRefsByName.putIfAbsent(databaseReference.fullName(), (DatabaseReference)databaseReference);
            this.databaseRefsByCatalogEntry.putIfAbsent(databaseReference.catalogEntry(), (DatabaseReference)databaseReference);
        });
        return databaseRef;
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedDatabaseName databaseName) {
        return this.delegate.getByAlias(databaseName).orElse(null);
    }

    private DatabaseReference lookupReferenceOnDelegate(NormalizedCatalogEntry catalogEntry) {
        return this.delegate.getByAlias(catalogEntry).orElse(null);
    }

    private DatabaseReference lookupReferenceByUuidOnDelegate(UUID databaseId) {
        return this.delegate.getByUuid(databaseId).orElse(null);
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        return this.delegate.getAllDatabaseReferences();
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferences() {
        return this.delegate.getCompositeDatabaseReferences();
    }

    @Override
    public void invalidateAll() {
        this.databaseRefsByName = new ConcurrentHashMap<NormalizedDatabaseName, DatabaseReference>();
        this.databaseRefsByCatalogEntry = new ConcurrentHashMap<NormalizedCatalogEntry, DatabaseReference>();
        this.databaseRefsByUUID = new ConcurrentHashMap<UUID, DatabaseReference>();
    }
}

