/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModel;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.database.SystemDatabaseReferenceRepository;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class CommunitySystemReferenceRepository
extends SystemDatabaseReferenceRepository {
    private static final DatabaseReference SYSTEM_DATABASE_REFERENCE = new DatabaseReferenceImpl.Internal(new NormalizedDatabaseName("system"), NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, true);
    private final Supplier<DatabaseContext> systemDatabaseSupplier;

    public CommunitySystemReferenceRepository(Supplier<DatabaseContext> systemDatabaseSupplier) {
        this.systemDatabaseSupplier = systemDatabaseSupplier;
    }

    @Override
    protected <T> T execute(Function<TopologyGraphDbmsModel, T> operation) {
        DatabaseContext databaseContext = this.systemDatabaseSupplier.get();
        GraphDatabaseAPI systemDb = databaseContext.databaseFacade();
        if (!systemDb.isAvailable(100L)) {
            throw new DatabaseShutdownException((Throwable)new DatabaseManagementException("System database is not (yet) available"));
        }
        try (Transaction tx = systemDb.beginTx();){
            CommunityTopologyGraphDbmsModel model = new CommunityTopologyGraphDbmsModel(tx);
            T t = operation.apply(model);
            return t;
        }
    }
}

