/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.CommittedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.reverse.CommandBatchCursors;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedEnvelopedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public final class DefaultReverseCommandBatchCursors
implements CommandBatchCursors {
    private final LogFile logFile;
    private final LogPosition beginning;
    private final LogEntryReader reader;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private long currentVersion;

    public DefaultReverseCommandBatchCursors(LogFile logFile, LogPosition beginning, LogEntryReader reader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        this.logFile = logFile;
        this.beginning = beginning;
        this.reader = reader;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.currentVersion = logFile.getHighestLogVersion();
    }

    @Override
    public Optional<CommandBatchCursor> next() {
        if (this.currentVersion < this.beginning.getLogVersion()) {
            return Optional.empty();
        }
        try {
            LogPosition position = this.getCursorStartPosition();
            CommandBatchCursor cursor = this.createCursor(position);
            --this.currentVersion;
            return Optional.of(cursor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private LogPosition getCursorStartPosition() throws IOException {
        while (this.currentVersion > this.beginning.getLogVersion()) {
            if (this.logFile.hasAnyEntries(this.currentVersion)) {
                return this.logFile.extractHeader(this.currentVersion).getStartPosition();
            }
            --this.currentVersion;
        }
        return this.beginning;
    }

    private CommandBatchCursor createCursor(LogPosition position) throws IOException {
        ReadableLogChannel channel;
        ReadableLogChannel readableLogChannel = channel = this.logFile.getReader(position, LogVersionBridge.NO_MORE_CHANNELS);
        Objects.requireNonNull(readableLogChannel);
        ReadableLogChannel readableLogChannel2 = readableLogChannel;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ReadAheadLogChannel.class, EnvelopeReadChannel.class}, (Object)readableLogChannel2, n)) {
            case 0 -> {
                ReadAheadLogChannel aheadChannel = (ReadAheadLogChannel)readableLogChannel2;
                yield new ReversedSingleFileCommandBatchCursor(aheadChannel, this.reader, this.failOnCorruptedLogFiles, this.monitor);
            }
            case 1 -> {
                EnvelopeReadChannel readChannel = (EnvelopeReadChannel)readableLogChannel2;
                yield new ReversedEnvelopedCommandBatchCursor(readChannel, this.reader, this.failOnCorruptedLogFiles, this.monitor, (EnvelopeReadChannel)this.logFile.getReader(position));
            }
            default -> EagerlyReversedCommandBatchCursor.eagerlyReverse(new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)channel, this.reader));
        };
    }

    @Override
    public void close() throws IOException {
    }
}

