/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.collection.diffset.DiffSets;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.index.IndexUsageStats;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.newapi.KernelSchemaRead;
import org.neo4j.storageengine.api.StorageSchemaReader;

final class SchemaReadCoreSnapshot
implements SchemaReadCore {
    private final StorageSchemaReader storageReader;
    private final TxStateHolder txStateHolder;
    private final IndexingService indexingService;
    private final IndexStatisticsStore indexStatisticsStore;
    private final AccessModeProvider accessModeProvider;

    SchemaReadCoreSnapshot(StorageSchemaReader storageReader, TxStateHolder txStateHolder, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, AccessModeProvider accessModeProvider) {
        this.storageReader = storageReader;
        this.txStateHolder = txStateHolder;
        this.indexingService = indexingService;
        this.indexStatisticsStore = indexStatisticsStore;
        this.accessModeProvider = accessModeProvider;
    }

    public IndexDescriptor indexGetForName(String name) {
        IndexDescriptor index = this.storageReader.indexGetForName(name);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            Predicate<IndexDescriptor> namePredicate = indexDescriptor -> indexDescriptor.getName().equals(name);
            Iterator indexes = this.txStateHolder.txState().indexChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)index));
            index = (IndexDescriptor)Iterators.singleOrNull((Iterator)indexes);
        }
        return index != null ? index : IndexDescriptor.NO_INDEX;
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        ConstraintDescriptor constraint = this.storageReader.constraintGetForName(name);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            Predicate<ConstraintDescriptor> namePredicate = constraintDescriptor -> constraintDescriptor.getName().equals(name);
            Iterator constraints = this.txStateHolder.txState().constraintsChanges().filterAdded(namePredicate).apply(Iterators.iterator((Object)constraint));
            constraint = (ConstraintDescriptor)Iterators.singleOrNull((Iterator)constraints);
        }
        return constraint;
    }

    public Iterator<IndexDescriptor> index(SchemaDescriptor schema) {
        Iterator indexes = this.storageReader.indexGetForSchema(schema);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            DiffSets diffSets = this.txStateHolder.txState().indexDiffSetsBySchema(schema);
            indexes = diffSets.apply(indexes);
        }
        return indexes;
    }

    public IndexDescriptor index(SchemaDescriptor schema, IndexType type) {
        IndexDescriptor index = this.storageReader.indexGetForSchemaAndType(schema, type);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            DiffSets indexChanges = this.txStateHolder.txState().indexChanges();
            if (index == null) {
                Set added = indexChanges.filterAdded(id -> id.getIndexType() == type && id.schema().equals((Object)schema)).getAdded();
                index = (IndexDescriptor)Iterators.singleOrNull(added.iterator());
            }
            if (indexChanges.isRemoved((Object)index)) {
                return IndexDescriptor.NO_INDEX;
            }
        }
        return index;
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        AccessMode accessMode = this.accessModeProvider.getAccessMode();
        if (accessMode.allowsTraverseNode(new int[]{labelId}) || accessMode.hasApplicableTraverseAllowPropertyRules(labelId)) {
            Iterator iterator = this.storageReader.indexesGetForLabel(labelId);
            if (this.txStateHolder.hasTxStateWithChanges()) {
                iterator = this.txStateHolder.txState().indexDiffSetsByLabel(labelId).apply(iterator);
            }
            return iterator;
        }
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        Iterator iterator = this.storageReader.indexesGetForRelationshipType(relationshipType);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            iterator = this.txStateHolder.txState().indexDiffSetsByRelationshipType(relationshipType).apply(iterator);
        }
        return iterator;
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        Iterator iterator = this.storageReader.indexesGetAll();
        if (this.txStateHolder.hasTxStateWithChanges()) {
            iterator = this.txStateHolder.txState().indexChanges().apply(iterator);
        }
        return iterator;
    }

    public InternalIndexState indexGetState(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.indexGetStateNonLocking(index);
    }

    public InternalIndexState indexGetStateNonLocking(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        if (this.txStateHolder.hasTxStateWithChanges() && SchemaReadCoreSnapshot.checkIndexState(index, (DiffSets<IndexDescriptor>)this.txStateHolder.txState().indexDiffSetsBySchema(index.schema()))) {
            return InternalIndexState.POPULATING;
        }
        return this.indexingService.getIndexProxy(index).getState();
    }

    public PopulationProgress indexGetPopulationProgress(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        if (this.txStateHolder.hasTxStateWithChanges() && SchemaReadCoreSnapshot.checkIndexState(index, (DiffSets<IndexDescriptor>)this.txStateHolder.txState().indexDiffSetsBySchema(index.schema()))) {
            return PopulationProgress.NONE;
        }
        return this.indexingService.getIndexProxy(index).getIndexPopulationProgress();
    }

    private static boolean checkIndexState(IndexDescriptor index, DiffSets<IndexDescriptor> diffSet) throws IndexNotFoundKernelException {
        if (diffSet.isAdded((Object)index)) {
            return true;
        }
        if (diffSet.isRemoved((Object)index)) {
            throw IndexNotFoundKernelException.indexDroppedInThisTransaction((IndexDescriptor)index);
        }
        return false;
    }

    public String indexGetFailure(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return this.indexingService.getIndexProxy(index).getPopulationFailure().asString();
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.constraintsGetForLabelNonLocking(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabelNonLocking(int labelId) {
        Iterator constraints = this.storageReader.constraintsGetForLabel(labelId);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            return this.txStateHolder.txState().constraintsChangesForLabel(labelId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.constraintsGetForRelationshipTypeNonLocking(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipTypeNonLocking(int typeId) {
        Iterator constraints = this.storageReader.constraintsGetForRelationshipType(typeId);
        if (this.txStateHolder.hasTxStateWithChanges()) {
            return this.txStateHolder.txState().constraintsChangesForRelationshipType(typeId).apply(constraints);
        }
        return constraints;
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.constraintsGetAllNonLocking();
    }

    public Iterator<ConstraintDescriptor> constraintsGetAllNonLocking() {
        Iterator constraints = this.storageReader.constraintsGetAll();
        if (this.txStateHolder.hasTxStateWithChanges()) {
            constraints = this.txStateHolder.txState().constraintsChanges().apply(constraints);
        }
        return constraints;
    }

    public IndexUsageStats indexUsageStats(IndexDescriptor index) throws IndexNotFoundKernelException {
        KernelSchemaRead.assertValidIndex(index);
        return this.indexStatisticsStore.usageStats(index.getId());
    }
}

