/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.internal.kernel.api.TokenSet;

public class Labels
implements TokenSet {
    private final int[] labelIds;

    private Labels(int[] labelIds) {
        this.labelIds = labelIds;
    }

    public static Labels from(int ... labels) {
        return new Labels(labels);
    }

    static Labels from(IntSet set) {
        return new Labels(set.toArray());
    }

    public int numberOfTokens() {
        return this.labelIds.length;
    }

    public int token(int offset) {
        return this.labelIds[offset];
    }

    public boolean contains(int token) {
        return PrimitiveArrays.contains((int[])this.labelIds, (int)token);
    }

    public String toString() {
        return "Labels" + Arrays.toString(this.labelIds);
    }

    public int[] all() {
        return this.labelIds;
    }
}

