/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.parallel;

import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.collection.Dependencies;
import org.neo4j.function.Suppliers;
import org.neo4j.internal.kernel.api.EntityLocks;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.CloseableResourceManager;
import org.neo4j.kernel.impl.api.OverridableSecurityContext;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextCursorTracer;
import org.neo4j.kernel.impl.api.parallel.ExecutionContextProcedureKernelTransaction;
import org.neo4j.kernel.impl.api.parallel.ThreadExecutionQueryContext;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.KernelProcedures;
import org.neo4j.kernel.impl.newapi.KernelRead;
import org.neo4j.kernel.impl.newapi.KernelSchemaRead;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.ElementIdMapper;

public class ThreadExecutionContext
implements ExecutionContext,
AutoCloseable {
    public static final TxStateHolder THREAD_EXECUTION_STATE_HOLDER = new TxStateHolder(){

        public TransactionState txState() {
            throw new UnsupportedOperationException("Accessing transaction state is not allowed during parallel execution");
        }

        public boolean hasTxStateWithChanges() {
            return false;
        }
    };
    private final CloseableResourceManager resourceManager = new CloseableResourceManager();
    private final DefaultPooledCursors cursors;
    private final CursorContext context;
    private final OverridableSecurityContext overridableSecurityContext;
    private final ExecutionContextCursorTracer cursorTracer;
    private final CursorContext ktxContext;
    private final KernelRead kernelRead;
    private final KernelProcedures.ForThreadExecutionContextScope procedures;
    private final TokenRead tokenRead;
    private final StoreCursors storageCursors;
    private final MemoryTracker contextTracker;
    private final SecurityAuthorizationHandler securityAuthorizationHandler;
    private final ElementIdMapper elementIdMapper;
    private final List<AutoCloseable> otherResources;
    private final ExecutionContextProcedureKernelTransaction ktx;
    private final Supplier<ClockContext> clockContextSupplier;
    private final QueryContext queryContext;
    private final EntityLocks entityLocks;
    private final SchemaRead schemaRead;
    private final AccessModeProvider accessModeProvider;

    public ThreadExecutionContext(DefaultPooledCursors cursors, CursorContext context, OverridableSecurityContext overridableSecurityContext, ExecutionContextCursorTracer cursorTracer, CursorContext ktxContext, TokenRead tokenRead, StoreCursors storageCursors, IndexMonitor monitor, MemoryTracker contextTracker, SecurityAuthorizationHandler securityAuthorizationHandler, StorageReader storageReader, SchemaState schemaState, IndexingService indexingService, IndexStatisticsStore indexStatisticsStore, Dependencies databaseDependencies, StorageLocks storageLocks, LockManager.Client lockClient, LockTracer lockTracer, ElementIdMapper elementIdMapper, KernelTransaction ktx, Supplier<ClockContext> clockContextSupplier, List<AutoCloseable> otherResources, ProcedureView procedureView, boolean multiVersioned, LogProvider logProvider) {
        this.cursors = cursors;
        this.context = context;
        this.overridableSecurityContext = overridableSecurityContext;
        this.cursorTracer = cursorTracer;
        this.ktxContext = ktxContext;
        this.tokenRead = tokenRead;
        this.storageCursors = storageCursors;
        this.contextTracker = contextTracker;
        this.securityAuthorizationHandler = securityAuthorizationHandler;
        this.otherResources = otherResources;
        this.elementIdMapper = elementIdMapper;
        this.ktx = new ExecutionContextProcedureKernelTransaction(ktx, this);
        this.clockContextSupplier = clockContextSupplier;
        this.queryContext = new ThreadExecutionQueryContext(this::dataRead, cursors, context, contextTracker, monitor);
        this.entityLocks = new EntityLocks(storageLocks, Suppliers.singleton((Object)lockTracer), lockClient, (AssertOpen)this.ktx);
        this.procedures = new KernelProcedures.ForThreadExecutionContextScope(this, databaseDependencies, overridableSecurityContext, this.ktx, securityAuthorizationHandler, clockContextSupplier, procedureView);
        this.accessModeProvider = () -> overridableSecurityContext.currentSecurityContext().mode();
        this.schemaRead = new KernelSchemaRead(schemaState, indexStatisticsStore, storageReader, (Locks)this.entityLocks, this.ktx, indexingService, (AssertOpen)this.ktx, this.accessModeProvider);
        this.kernelRead = new KernelRead(storageReader, this.tokenRead(), cursors, storageCursors, (Locks)this.entityLocks, this.queryContext, THREAD_EXECUTION_STATE_HOLDER, this.schemaRead, indexingService, this.memoryTracker(), multiVersioned, (AssertOpen)this.ktx, this.accessModeProvider, true, logProvider);
    }

    public Supplier<ClockContext> clockContextSupplier() {
        return this.clockContextSupplier;
    }

    public OverridableSecurityContext overridableSecurityContext() {
        return this.overridableSecurityContext;
    }

    public CursorContext cursorContext() {
        return this.context;
    }

    public DefaultPooledCursors cursors() {
        return this.cursors;
    }

    public SecurityContext securityContext() {
        return this.overridableSecurityContext.currentSecurityContext();
    }

    public Read dataRead() {
        return this.kernelRead;
    }

    public TokenRead tokenRead() {
        return this.tokenRead;
    }

    public SchemaRead schemaRead() {
        return this.schemaRead;
    }

    public Procedures procedures() {
        return this.procedures;
    }

    public void complete() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>(this.otherResources);
        resources.add(this.resourceManager::closeAllCloseableResources);
        resources.add(this.cursors::release);
        resources.add((AutoCloseable)this.storageCursors);
        IOUtils.closeAllUnchecked(resources);
        this.cursorTracer.complete();
    }

    public void report() {
        this.mergeBlocked(this.cursorTracer, this.contextTracker);
    }

    public ElementIdMapper elementIdMapper() {
        return this.elementIdMapper;
    }

    public void performCheckBeforeOperation() {
        this.ktx.assertOpen();
    }

    public boolean isTransactionOpen() {
        return this.ktx.isOpen();
    }

    public QueryContext queryContext() {
        return this.queryContext;
    }

    public AccessModeProvider accessModeProvider() {
        return this.accessModeProvider;
    }

    public TxStateHolder txStateHolder() {
        return THREAD_EXECUTION_STATE_HOLDER;
    }

    public MemoryTracker memoryTracker() {
        return this.contextTracker;
    }

    public Locks locks() {
        return this.entityLocks;
    }

    public SecurityAuthorizationHandler securityAuthorizationHandler() {
        return this.securityAuthorizationHandler;
    }

    @Override
    public void close() {
        if (!this.cursorTracer.isCompleted()) {
            throw new IllegalStateException("Execution context closed before it was marked as completed.");
        }
        this.mergeBlocked(this.cursorTracer, this.contextTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBlocked(ExecutionContextCursorTracer cursorTracer, MemoryTracker contextTracker) {
        CursorContext cursorContext = this.ktxContext;
        synchronized (cursorContext) {
            this.mergeUnblocked(cursorTracer, contextTracker);
        }
        VarHandle.fullFence();
    }

    private void mergeUnblocked(ExecutionContextCursorTracer cursorTracer, MemoryTracker contextTracker) {
        this.ktxContext.merge(cursorTracer.snapshot());
        contextTracker.reset();
    }

    public void registerCloseableResource(AutoCloseable closeableResource) {
        this.resourceManager.registerCloseableResource(closeableResource);
    }

    public void unregisterCloseableResource(AutoCloseable closeableResource) {
        this.resourceManager.unregisterCloseableResource(closeableResource);
    }
}

