/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexPopulationFailedKernelException
extends KernelException {
    private static final String FORMAT_MESSAGE = "Failed to populate index %s";

    private IndexPopulationFailedKernelException(ErrorGqlStatusObject gqlStatusObject, String indexUserDescription, Throwable cause) {
        super(gqlStatusObject, (Status)Status.Schema.IndexCreationFailed, cause, FORMAT_MESSAGE, new Object[]{indexUserDescription});
    }

    public IndexPopulationFailedKernelException(String indexUserDescription, String message) {
        super((Status)Status.Schema.IndexCreationFailed, "Failed to populate index %s, due to " + message, new Object[]{indexUserDescription});
    }

    private IndexPopulationFailedKernelException(ErrorGqlStatusObject gqlStatusObject, String indexUserDescription, String message) {
        super(gqlStatusObject, (Status)Status.Schema.IndexCreationFailed, "Failed to populate index %s, due to " + message, new Object[]{indexUserDescription});
    }

    public static IndexPopulationFailedKernelException indexPopulationFailed(String indexUserDescription, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N61).withParam(GqlParams.StringParam.idx, indexUserDescription).build();
        return new IndexPopulationFailedKernelException(gql, indexUserDescription, cause);
    }

    public static IndexPopulationFailedKernelException indexPopulationFailed(String indexUserDescription, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N61).withParam(GqlParams.StringParam.idx, indexUserDescription).build();
        return new IndexPopulationFailedKernelException(gql, indexUserDescription, message);
    }
}

