/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

public class LatestCheckPointFinder {
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fileSystem;
    private final LogEntryReader<ReadableLogChannel> logEntryReader;

    public LatestCheckPointFinder(PhysicalLogFiles logFiles, FileSystemAbstraction fileSystem, LogEntryReader<ReadableLogChannel> logEntryReader) {
        this.logFiles = logFiles;
        this.fileSystem = fileSystem;
        this.logEntryReader = logEntryReader;
    }

    public LatestCheckPoint find(long fromVersionBackwards) throws IOException {
        PhysicalLogVersionedStoreChannel channel;
        long version = fromVersionBackwards;
        long versionToSearchForCommits = fromVersionBackwards;
        LogEntryStart latestStartEntry = null;
        long oldestVersionFound = -1L;
        while (version >= 0L && (channel = PhysicalLogFile.tryOpenForVersion(this.logFiles, this.fileSystem, version)) != null) {
            oldestVersionFound = version;
            CheckPoint latestCheckPoint = null;
            ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel(channel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
            try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, recoveredDataChannel);){
                while (cursor.next()) {
                    LogEntry entry = cursor.get();
                    if (entry instanceof CheckPoint) {
                        latestCheckPoint = (CheckPoint)entry.as();
                    }
                    if (!(entry instanceof LogEntryStart) || version != versionToSearchForCommits) continue;
                    latestStartEntry = (LogEntryStart)entry.as();
                }
            }
            if (latestCheckPoint != null) {
                boolean commitsAfterCheckPoint = latestStartEntry != null && latestStartEntry.getStartPosition().compareTo(latestCheckPoint.getLogPosition()) >= 0;
                return new LatestCheckPoint(latestCheckPoint, commitsAfterCheckPoint, oldestVersionFound);
            }
            --version;
            if (latestStartEntry != null) continue;
            --versionToSearchForCommits;
        }
        return new LatestCheckPoint(null, latestStartEntry != null, oldestVersionFound);
    }

    public static class LatestCheckPoint {
        public final CheckPoint checkPoint;
        public final boolean commitsAfterCheckPoint;
        public final long oldestLogVersionFound;

        public LatestCheckPoint(CheckPoint checkPoint, boolean commitsAfterCheckPoint, long oldestLogVersionFound) {
            this.checkPoint = checkPoint;
            this.commitsAfterCheckPoint = commitsAfterCheckPoint;
            this.oldestLogVersionFound = oldestLogVersionFound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatestCheckPoint that = (LatestCheckPoint)o;
            return this.commitsAfterCheckPoint == that.commitsAfterCheckPoint && this.oldestLogVersionFound == that.oldestLogVersionFound && (this.checkPoint == null ? that.checkPoint == null : this.checkPoint.equals(that.checkPoint));
        }

        public int hashCode() {
            int result = this.checkPoint != null ? this.checkPoint.hashCode() : 0;
            result = 31 * result + (this.commitsAfterCheckPoint ? 1 : 0);
            result = 31 * result + (int)(this.oldestLogVersionFound ^ this.oldestLogVersionFound >>> 32);
            return result;
        }

        public String toString() {
            return "LatestCheckPoint{checkPoint=" + this.checkPoint + ", commitsAfterCheckPoint=" + this.commitsAfterCheckPoint + ", oldestLogVersionFound=" + this.oldestLogVersionFound + '}';
        }
    }
}

