/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.RecoveryLabelScanWriterProvider;
import org.neo4j.kernel.impl.api.RecoveryLegacyIndexApplierLookup;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.RecoveryIndexingUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.rotation.StoreFlusher;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;

public class DefaultRecoverySPI
implements Recovery.SPI {
    private final RecoveryLabelScanWriterProvider labelScanWriters;
    private final RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup;
    private final StoreFlusher storeFlusher;
    private final NeoStores neoStores;
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fs;
    private final LogVersionRepository logVersionRepository;
    private final PositionToRecoverFrom positionToRecoverFrom;
    private final RecoveryIndexingUpdatesValidator indexUpdatesValidator;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final Visitor<CommittedTransactionRepresentation, Exception> recoveryVisitor;

    public DefaultRecoverySPI(RecoveryLabelScanWriterProvider labelScanWriters, RecoveryLegacyIndexApplierLookup legacyIndexApplierLookup, StoreFlusher storeFlusher, NeoStores neoStores, PhysicalLogFiles logFiles, FileSystemAbstraction fs, LogVersionRepository logVersionRepository, LatestCheckPointFinder checkPointFinder, RecoveryIndexingUpdatesValidator indexUpdatesValidator, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, TransactionRepresentationStoreApplier storeApplier) {
        this.labelScanWriters = labelScanWriters;
        this.legacyIndexApplierLookup = legacyIndexApplierLookup;
        this.storeFlusher = storeFlusher;
        this.neoStores = neoStores;
        this.logFiles = logFiles;
        this.fs = fs;
        this.logVersionRepository = logVersionRepository;
        this.indexUpdatesValidator = indexUpdatesValidator;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.positionToRecoverFrom = new PositionToRecoverFrom(checkPointFinder);
        this.recoveryVisitor = new RecoveryVisitor(storeApplier, indexUpdatesValidator);
    }

    @Override
    public void forceEverything() {
        try {
            this.labelScanWriters.close();
            this.legacyIndexApplierLookup.close();
            this.indexUpdatesValidator.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.storeFlusher.forceEverything();
    }

    @Override
    public LogPosition getPositionToRecoverFrom() throws IOException {
        return this.positionToRecoverFrom.apply(this.logVersionRepository.getCurrentLogVersion());
    }

    @Override
    public Visitor<CommittedTransactionRepresentation, Exception> startRecovery() {
        this.neoStores.deleteIdGenerators();
        return this.recoveryVisitor;
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactions(position);
    }

    @Override
    public void allTransactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition positionAfterLastRecoveredTransaction) throws Exception {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredTransaction.getCommitEntry().getTxId(), LogEntryStart.checksum(lastRecoveredTransaction.getStartEntry()), lastRecoveredTransaction.getCommitEntry().getTimeWritten(), positionAfterLastRecoveredTransaction.getByteOffset(), positionAfterLastRecoveredTransaction.getLogVersion());
        this.fs.truncate(this.logFiles.getLogFileForVersion(positionAfterLastRecoveredTransaction.getLogVersion()), positionAfterLastRecoveredTransaction.getByteOffset());
    }

    static class RecoveryVisitor
    implements Visitor<CommittedTransactionRepresentation, Exception> {
        private final TransactionRepresentationStoreApplier storeApplier;
        private final RecoveryIndexingUpdatesValidator indexUpdatesValidator;

        public RecoveryVisitor(TransactionRepresentationStoreApplier storeApplier, RecoveryIndexingUpdatesValidator indexUpdatesValidator) {
            this.storeApplier = storeApplier;
            this.indexUpdatesValidator = indexUpdatesValidator;
        }

        @Override
        public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            try (LockGroup locks = new LockGroup();
                 ValidatedIndexUpdates indexUpdates = this.prepareIndexUpdates(txRepresentation);){
                this.storeApplier.apply(txRepresentation, indexUpdates, locks, txId, TransactionApplicationMode.RECOVERY);
            }
            return false;
        }

        private ValidatedIndexUpdates prepareIndexUpdates(TransactionRepresentation txRepresentation) throws IOException {
            return this.indexUpdatesValidator.validate(txRepresentation);
        }
    }
}

