/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;

public class Legacy20RelationshipStoreReader
implements LegacyRelationshipStoreReader {
    public static final String FROM_VERSION = "RelationshipStore v0.A.1";
    public static final int RECORD_SIZE = 33;
    private final StoreChannel fileChannel;
    private final long maxId;

    public Legacy20RelationshipStoreReader(FileSystemAbstraction fs, File fileName) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 33L;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public int getRecordSize() {
        return 33;
    }

    @Override
    public Iterator<RelationshipRecord> iterator(final long approximateStartId) throws IOException {
        final LegacyRelationshipStoreReader.ReusableRelationship rel = new LegacyRelationshipStoreReader.ReusableRelationship();
        final ByteBuffer buffer = ByteBuffer.allocateDirect(135168);
        final long fileSize = this.fileChannel.size();
        return new PrefetchingIterator<RelationshipRecord>(){
            private long position;
            private final Collection<RelationshipRecord> pageRecords;
            private Iterator<RelationshipRecord> pageRecordsIterator;
            {
                this.position = approximateStartId * 33L - approximateStartId * 33L % (long)buffer.capacity();
                this.pageRecords = new ArrayList<RelationshipRecord>();
                this.pageRecordsIterator = IteratorUtil.emptyIterator();
            }

            @Override
            protected RelationshipRecord fetchNextOrNull() {
                if (this.pageRecordsIterator.hasNext()) {
                    return this.pageRecordsIterator.next();
                }
                while (this.position < fileSize) {
                    buffer.clear();
                    try {
                        Legacy20RelationshipStoreReader.this.fileChannel.read(buffer, this.position);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.pageRecords.clear();
                    for (int recordOffset = 0; recordOffset < buffer.capacity() && (long)recordOffset + this.position < fileSize; recordOffset += 33) {
                        buffer.position(recordOffset);
                        long id = (this.position + (long)recordOffset) / 33L;
                        Legacy20RelationshipStoreReader.this.readRecord(buffer, id, rel);
                        if (!rel.inUse()) continue;
                        this.pageRecords.add(rel.createRecord());
                    }
                    this.position += (long)buffer.capacity();
                    this.pageRecordsIterator = this.pageRecords.iterator();
                    if (!this.pageRecordsIterator.hasNext()) continue;
                    return this.pageRecordsIterator.next();
                }
                return null;
            }
        };
    }

    private void readRecord(ByteBuffer buffer, long id, LegacyRelationshipStoreReader.ReusableRelationship rel) {
        boolean inUse;
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (inUse) {
            long firstNode = Legacy20Store.getUnsignedInt(buffer);
            long firstNodeMod = (inUseByte & 0xEL) << 31;
            long secondNode = Legacy20Store.getUnsignedInt(buffer);
            long typeInt = buffer.getInt();
            long secondNodeMod = (typeInt & 0x70000000L) << 4;
            int type = (int)(typeInt & 0xFFFFL);
            firstNode = Legacy20Store.longFromIntAndMod(firstNode, firstNodeMod);
            secondNode = Legacy20Store.longFromIntAndMod(secondNode, secondNodeMod);
            long firstPrevRel = Legacy20Store.getUnsignedInt(buffer);
            long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
            firstPrevRel = Legacy20Store.longFromIntAndMod(firstPrevRel, firstPrevRelMod);
            long firstNextRel = Legacy20Store.getUnsignedInt(buffer);
            long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
            firstNextRel = Legacy20Store.longFromIntAndMod(firstNextRel, firstNextRelMod);
            long secondPrevRel = Legacy20Store.getUnsignedInt(buffer);
            long secondPrevRelMod = (typeInt & 0x380000L) << 13;
            secondPrevRel = Legacy20Store.longFromIntAndMod(secondPrevRel, secondPrevRelMod);
            long secondNextRel = Legacy20Store.getUnsignedInt(buffer);
            long secondNextRelMod = (typeInt & 0x70000L) << 16;
            secondNextRel = Legacy20Store.longFromIntAndMod(secondNextRel, secondNextRelMod);
            long nextProp = Legacy20Store.getUnsignedInt(buffer);
            long nextPropMod = (inUseByte & 0xF0L) << 28;
            nextProp = Legacy20Store.longFromIntAndMod(nextProp, nextPropMod);
            rel.reset(id, true, firstNode, secondNode, type, firstPrevRel, firstNextRel, secondNextRel, secondPrevRel, nextProp);
        } else {
            rel.reset(id, false, -1L, -1L, -1, -1L, -1L, -1L, -1L, -1L);
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }
}

