/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.store.RecordStore;

public class StoreIdIterator
implements PrimitiveLongIterator {
    private final RecordStore<?> store;
    private long targetId;
    private long id;
    private final boolean forward;

    public StoreIdIterator(RecordStore<?> store) {
        this(store, true);
    }

    public StoreIdIterator(RecordStore<?> store, boolean forward) {
        this.store = store;
        this.id = forward ? (long)store.getNumberOfReservedLowIds() : store.getHighId();
        this.forward = forward;
    }

    public String toString() {
        return String.format("%s[id=%s/%s; store=%s]", this.getClass().getSimpleName(), this.id, this.targetId, this.store);
    }

    public boolean hasNext() {
        if (this.forward) {
            if (this.id < this.targetId) {
                return true;
            }
            this.targetId = this.store.getHighId();
            return this.id < this.targetId;
        }
        return this.id > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        long l;
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.forward ? String.format("ID [%s] has exceeded the high ID [%s] of %s.", this.id, this.targetId, this.store) : String.format("ID [%s] has exceeded the low ID [%s] of %s.", this.id, this.targetId, this.store));
        }
        try {
            l = this.id;
            this.id += (long)(this.forward ? 1 : -1);
        }
        catch (Throwable throwable) {
            this.id += (long)(this.forward ? 1 : -1);
            throw throwable;
        }
        return l;
    }
}

