/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Recovery
extends LifecycleAdapter {
    private final SPI spi;
    private final Monitor monitor;
    private int numberOfRecoveredTransactions;
    private boolean recoveredLog = false;

    public Recovery(SPI spi, Monitor monitor) {
        this.spi = spi;
        this.monitor = monitor;
    }

    @Override
    public void init() throws Throwable {
        LogPosition recoveryToPosition;
        LogPosition recoveryFromPosition = this.spi.getPositionToRecoverFrom();
        if (LogPosition.UNSPECIFIED.equals(recoveryFromPosition)) {
            return;
        }
        this.monitor.recoveryRequired(recoveryFromPosition);
        CommittedTransactionRepresentation lastTransaction = null;
        Visitor<CommittedTransactionRepresentation, Exception> recoveryVisitor = this.spi.startRecovery();
        try (TransactionCursor transactionsToRecover = this.spi.getTransactions(recoveryFromPosition);){
            while (transactionsToRecover.next()) {
                lastTransaction = (CommittedTransactionRepresentation)transactionsToRecover.get();
                long txId = lastTransaction.getCommitEntry().getTxId();
                recoveryVisitor.visit(lastTransaction);
                this.monitor.transactionRecovered(txId);
                ++this.numberOfRecoveredTransactions;
            }
            recoveryToPosition = transactionsToRecover.position();
        }
        if (lastTransaction != null) {
            this.spi.allTransactionsRecovered(lastTransaction, recoveryToPosition);
        }
        this.recoveredLog = true;
        this.spi.forceEverything();
    }

    @Override
    public void start() throws Throwable {
        if (this.recoveredLog) {
            this.spi.forceEverything();
            this.monitor.recoveryCompleted(this.numberOfRecoveredTransactions);
        }
    }

    public static interface SPI {
        public void forceEverything();

        public TransactionCursor getTransactions(LogPosition var1) throws IOException;

        public LogPosition getPositionToRecoverFrom() throws IOException;

        public Visitor<CommittedTransactionRepresentation, Exception> startRecovery();

        public void allTransactionsRecovered(CommittedTransactionRepresentation var1, LogPosition var2) throws Exception;
    }

    public static interface Monitor {
        public void recoveryRequired(LogPosition var1);

        public void transactionRecovered(long var1);

        public void recoveryCompleted(int var1);
    }
}

