/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.ChunkedNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

abstract class DynamicNumberArray<N extends NumberArray>
extends ChunkedNumberArray<N> {
    protected final NumberArrayFactory factory;

    DynamicNumberArray(NumberArrayFactory factory, long chunkSize) {
        super(chunkSize);
        this.factory = factory;
        this.chunks = new NumberArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected N ensureChunkAt(long index) {
        if (index >= this.length()) {
            DynamicNumberArray dynamicNumberArray = this;
            synchronized (dynamicNumberArray) {
                if (index >= this.length()) {
                    NumberArray[] newChunks = Arrays.copyOf(this.chunks, this.chunkIndex(index) + 1);
                    for (int i = this.chunks.length; i < newChunks.length; ++i) {
                        newChunks[i] = this.addChunk(this.chunkSize);
                    }
                    this.chunks = newChunks;
                }
            }
        }
        return this.chunkAt(index);
    }

    protected abstract N addChunk(long var1);
}

