/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.util.Bits;

public enum ShortArray {
    BOOLEAN(PropertyType.BOOL, 1, (Class)Boolean.class, (Class)Boolean.TYPE){

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            return 1;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (boolean value : (boolean[])array) {
                    result.put(value ? 1 : 0, 1);
                }
            } else {
                Boolean[] arr$ = (Boolean[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    boolean value = arr$[i$];
                    result.put(value ? 1 : 0, 1);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_BOOLEAN_ARRAY;
            }
            boolean[] result = new boolean[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getByte(requiredBits) != 0;
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_BOOLEAN_ARRAY;
        }
    }
    ,
    BYTE(PropertyType.BYTE, 8, (Class)Byte.class, (Class)Byte.TYPE){

        int getRequiredBits(byte value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (byte value : (byte[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Byte[] arr$ = (Byte[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    byte value = arr$[i$];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (byte b : (byte[])array) {
                    result.put(b, requiredBits);
                }
            } else {
                Byte[] arr$ = (Byte[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    byte b = arr$[i$];
                    result.put(b, requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] result = new byte[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getByte(requiredBits);
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_BYTE_ARRAY;
        }
    }
    ,
    SHORT(PropertyType.SHORT, 16, (Class)Short.class, (Class)Short.TYPE){

        int getRequiredBits(short value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (short value : (short[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Short[] arr$ = (Short[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    short value = arr$[i$];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (short value : (short[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Short[] arr$ = (Short[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    short value = arr$[i$];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_SHORT_ARRAY;
            }
            short[] result = new short[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getShort(requiredBits);
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_SHORT_ARRAY;
        }
    }
    ,
    CHAR(PropertyType.CHAR, 16, (Class)Character.class, (Class)Character.TYPE){

        int getRequiredBits(char value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (char value : (char[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Character[] arr$ = (Character[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    char value = arr$[i$].charValue();
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (char value : (char[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Character[] arr$ = (Character[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    char value = arr$[i$].charValue();
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_CHAR_ARRAY;
            }
            char[] result = new char[length];
            for (int i = 0; i < length; ++i) {
                result[i] = (char)bits.getShort(requiredBits);
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_CHAR_ARRAY;
        }
    }
    ,
    INT(PropertyType.INT, 32, (Class)Integer.class, (Class)Integer.TYPE){

        int getRequiredBits(int value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (int value : (int[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Integer[] arr$ = (Integer[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int value = arr$[i$];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (int value : (int[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Integer[] arr$ = (Integer[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int value = arr$[i$];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_INT_ARRAY;
            }
            int[] result = new int[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getInt(requiredBits);
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_INT_ARRAY;
        }
    }
    ,
    LONG(PropertyType.LONG, 64, (Class)Long.class, (Class)Long.TYPE){

        @Override
        public int getRequiredBits(long value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (long value : (long[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Long[] arr$ = (Long[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long value = arr$[i$];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (long value : (long[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Long[] arr$ = (Long[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long value = arr$[i$];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_LONG_ARRAY;
            }
            long[] result = new long[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getLong(requiredBits);
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_LONG_ARRAY;
        }
    }
    ,
    FLOAT(PropertyType.FLOAT, 32, (Class)Float.class, (Class)Float.TYPE){

        int getRequiredBits(float value) {
            int v = Float.floatToIntBits(value);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (float value : (float[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Float[] arr$ = (Float[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    float value = arr$[i$].floatValue();
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (float value : (float[])array) {
                    result.put(Float.floatToIntBits(value), requiredBits);
                }
            } else {
                Float[] arr$ = (Float[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    float value = arr$[i$].floatValue();
                    result.put(Float.floatToIntBits(value), requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_FLOAT_ARRAY;
            }
            float[] result = new float[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Float.intBitsToFloat(bits.getInt(requiredBits));
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_FLOAT_ARRAY;
        }
    }
    ,
    DOUBLE(PropertyType.DOUBLE, 64, (Class)Double.class, (Class)Double.TYPE){

        int getRequiredBits(double value) {
            long v = Double.doubleToLongBits(value);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (double value : (double[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Double[] arr$ = (Double[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    double value = arr$[i$];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, Bits result) {
            if (ShortArray.isPrimitive(array)) {
                for (double value : (double[])array) {
                    result.put(Double.doubleToLongBits(value), requiredBits);
                }
            } else {
                Double[] arr$ = (Double[])array;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    double value = arr$[i$];
                    result.put(Double.doubleToLongBits(value), requiredBits);
                }
            }
        }

        @Override
        public Object createArray(int length, Bits bits, int requiredBits) {
            if (length == 0) {
                return EMPTY_DOUBLE_ARRAY;
            }
            double[] result = new double[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Double.longBitsToDouble(bits.getLong(requiredBits));
            }
            return result;
        }

        @Override
        public Object createEmptyArray() {
            return EMPTY_DOUBLE_ARRAY;
        }
    };

    public static final boolean[] EMPTY_BOOLEAN_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final short[] EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY;
    public static final int[] EMPTY_INT_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY;
    public static final float[] EMPTY_FLOAT_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY;
    private static final ShortArray[] TYPES;
    private static final Map<Class<?>, ShortArray> all;
    final int maxBits;
    private final Class<?> boxedClass;
    private final Class<?> primitiveClass;
    private final PropertyType type;

    private static boolean isPrimitive(Object array) {
        return array.getClass().getComponentType().isPrimitive();
    }

    private ShortArray(PropertyType type, int maxBits, Class<?> boxedClass, Class<?> primitiveClass) {
        this.type = type;
        this.maxBits = maxBits;
        this.boxedClass = boxedClass;
        this.primitiveClass = primitiveClass;
    }

    public int intValue() {
        return this.type.intValue();
    }

    public abstract Object createArray(int var1, Bits var2, int var3);

    public static boolean encode(int keyId, Object array, PropertyBlock target, int payloadSizeInBytes) {
        int arrayLength = Array.getLength(array);
        if (arrayLength > 63) {
            return false;
        }
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            return false;
        }
        int requiredBits = type.calculateRequiredBitsForArray(array, arrayLength);
        if (!ShortArray.willFit(requiredBits, arrayLength, payloadSizeInBytes)) {
            return false;
        }
        int numberOfBytes = ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits) * 8;
        if (Bits.requiredLongs(numberOfBytes) > PropertyType.getPayloadSizeLongs()) {
            return false;
        }
        Bits result = Bits.bits(numberOfBytes);
        ShortArray.writeHeader(keyId, type, arrayLength, requiredBits, result);
        type.writeAll(array, arrayLength, requiredBits, result);
        target.setValueBlocks(result.getLongs());
        return true;
    }

    private static void writeHeader(int keyId, ShortArray type, int arrayLength, int requiredBits, Bits result) {
        result.put(keyId, 24);
        result.put(PropertyType.SHORT_ARRAY.intValue(), 4);
        result.put(type.type.intValue(), 4);
        result.put(arrayLength, 6);
        result.put(requiredBits, 6);
    }

    public static Object decode(PropertyBlock block) {
        Bits bits = Bits.bitsFromLongs(Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        return ShortArray.decode(bits);
    }

    public static Object decode(Bits bits) {
        ShortArray type;
        bits.getInt(24);
        bits.getByte(4);
        byte typeId = bits.getByte(4);
        byte arrayLength = bits.getByte(6);
        int requiredBits = bits.getByte(6);
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        return (type = ShortArray.typeOf(typeId)) == null ? null : type.createArray(arrayLength, bits, requiredBits);
    }

    private static boolean willFit(int requiredBits, int arrayLength, int payloadSizeInBytes) {
        int totalBitsRequired = requiredBits * arrayLength;
        int maxBits = payloadSizeInBytes * 8 - 24 - 4 - 4 - 6 - 6;
        return totalBitsRequired <= maxBits;
    }

    public int calculateRequiredBitsForArray(Object array, int arrayLength) {
        if (arrayLength == 0) {
            return 0;
        }
        return this.getRequiredBits(array, arrayLength);
    }

    public int getRequiredBits(long value) {
        int highest = 1;
        long mask = 1L;
        int i = 1;
        while (i <= this.maxBits) {
            if ((mask & value) != 0L) {
                highest = i;
            }
            ++i;
            mask <<= 1;
        }
        return highest;
    }

    abstract int getRequiredBits(Object var1, int var2);

    public static ShortArray typeOf(byte typeId) {
        return TYPES[typeId - 1];
    }

    public static ShortArray typeOf(Object array) {
        return all.get(array.getClass().getComponentType());
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int highInt = (int)(firstBlock >>> 32);
        int arrayLength = highInt & 0x3F;
        int requiredBits = (highInt >>>= 6) & 0x3F;
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        return ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits);
    }

    public static int calculateNumberOfBlocksUsed(int arrayLength, int requiredBits) {
        int bitsForItems = arrayLength * requiredBits;
        int totalBits = 44 + bitsForItems;
        int result = (totalBits - 1) / 64 + 1;
        return result;
    }

    public abstract void writeAll(Object var1, int var2, int var3, Bits var4);

    public Object createEmptyArray() {
        return Array.newInstance(this.primitiveClass, 0);
    }

    static {
        EMPTY_BOOLEAN_ARRAY = new boolean[0];
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_SHORT_ARRAY = new short[0];
        EMPTY_CHAR_ARRAY = new char[0];
        EMPTY_INT_ARRAY = new int[0];
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_FLOAT_ARRAY = new float[0];
        EMPTY_DOUBLE_ARRAY = new double[0];
        TYPES = ShortArray.values();
        all = new IdentityHashMap(TYPES.length * 2);
        for (ShortArray shortArray : TYPES) {
            all.put(shortArray.primitiveClass, shortArray);
            all.put(shortArray.boxedClass, shortArray);
        }
    }
}

