/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class OnlineIndexUpdatesValidator
implements IndexUpdatesValidator {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final PropertyLoader propertyLoader;
    private final IndexingService indexing;
    private final KernelHealth kernelHealth;
    private final IndexUpdateMode updateMode;

    public OnlineIndexUpdatesValidator(NeoStores neoStore, KernelHealth kernelHealth, PropertyLoader propertyLoader, IndexingService indexing, IndexUpdateMode updateMode) {
        this.kernelHealth = kernelHealth;
        this.updateMode = updateMode;
        this.nodeStore = neoStore.getNodeStore();
        this.propertyStore = neoStore.getPropertyStore();
        this.propertyLoader = propertyLoader;
        this.indexing = indexing;
    }

    @Override
    public ValidatedIndexUpdates validate(TransactionRepresentation transaction) throws IOException {
        NodePropertyCommandsExtractor extractor = new NodePropertyCommandsExtractor();
        try {
            transaction.accept(extractor);
        }
        catch (IOException cause) {
            this.kernelHealth.panic(cause);
            throw cause;
        }
        if (!extractor.containsAnyNodeOrPropertyUpdate()) {
            return ValidatedIndexUpdates.NONE;
        }
        LazyIndexUpdates updates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyLoader, extractor.propertyCommandsByNodeIds, extractor.nodeCommandsById);
        return this.indexing.validate(updates, this.updateMode);
    }
}

