/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.cursor;

import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntStack;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.api.cursor.PropertyItem;

public interface EntityItem {
    public long id();

    public Cursor<PropertyItem> properties();

    public Cursor<PropertyItem> property(int var1);

    public boolean hasProperty(int var1);

    public Object getProperty(int var1);

    public PrimitiveIntCollection getPropertyKeys();

    public static abstract class EntityItemHelper
    implements EntityItem {
        @Override
        public boolean hasProperty(int propertyKeyId) {
            try (Cursor<PropertyItem> cursor = this.property(propertyKeyId);){
                boolean bl = cursor.next();
                return bl;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object getProperty(int propertyKeyId) {
            try (Cursor<PropertyItem> cursor = this.property(propertyKeyId);){
                if (!cursor.next()) return null;
                Object object = ((PropertyItem)cursor.get()).value();
                return object;
            }
            catch (NotFoundException e) {
                return null;
            }
        }

        @Override
        public PrimitiveIntCollection getPropertyKeys() {
            PrimitiveIntStack keys = new PrimitiveIntStack();
            try (Cursor<PropertyItem> properties = this.properties();){
                while (properties.next()) {
                    keys.push(((PropertyItem)properties.get()).propertyKeyId());
                }
            }
            return keys;
        }
    }
}

