/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.BufferingIdGenerator;
import org.neo4j.kernel.impl.store.id.IdGenerator;

public class BufferingIdGeneratorFactory
extends IdGeneratorFactory.Delegate {
    private final BufferingIdGenerator[] overriddenIdGenerators = new BufferingIdGenerator[IdType.values().length];
    private Supplier<KernelTransactionsSnapshot> boundaries;

    public BufferingIdGeneratorFactory(IdGeneratorFactory delegate) {
        super(delegate);
    }

    public void initialize(Supplier<KernelTransactionsSnapshot> boundaries) {
        this.boundaries = boundaries;
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.initialize(boundaries);
        }
    }

    @Override
    public IdGenerator open(File filename, int grabSize, IdType idType, long highId) {
        IdGenerator generator = super.open(filename, grabSize, idType, highId);
        if (idType.allowAggressiveReuse()) {
            BufferingIdGenerator bufferingGenerator = new BufferingIdGenerator(generator);
            if (this.boundaries != null) {
                bufferingGenerator.initialize(this.boundaries);
            }
            this.overriddenIdGenerators[idType.ordinal()] = bufferingGenerator;
            generator = bufferingGenerator;
        }
        return generator;
    }

    @Override
    public IdGenerator get(IdType idType) {
        BufferingIdGenerator generator = this.overriddenIdGenerators[idType.ordinal()];
        return generator != null ? generator : super.get(idType);
    }

    public void maintenance() {
        for (BufferingIdGenerator generator : this.overriddenIdGenerators) {
            if (generator == null) continue;
            generator.maintenance();
        }
    }
}

