/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProviderImpl;
import org.neo4j.kernel.impl.coreapi.LegacyIndexProxy;
import org.neo4j.kernel.impl.coreapi.NodeAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DataSourceModule {
    public final ThreadToStatementContextBridge threadToTransactionBridge;
    public final NodeManager nodeManager;
    public final NeoStoreDataSource neoStoreDataSource;
    public final IndexManager indexManager;
    public final Schema schema;
    public final Supplier<KernelAPI> kernelAPI;
    public final Supplier<QueryExecutionEngine> queryExecutor;
    public final KernelEventHandlers kernelEventHandlers;
    public final TransactionEventHandlers transactionEventHandlers;
    public final Supplier<StoreId> storeId;

    public DataSourceModule(final GraphDatabaseFacadeFactory.Dependencies dependencies, final PlatformModule platformModule, EditionModule editionModule) {
        final Dependencies deps = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        final GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        RelationshipTypeTokenHolder relationshipTypeTokenHolder = editionModule.relationshipTypeTokenHolder;
        File storeDir = platformModule.storeDir;
        DiagnosticsManager diagnosticsManager = platformModule.diagnosticsManager;
        this.threadToTransactionBridge = deps.satisfyDependency(life.add(new ThreadToStatementContextBridge()));
        this.nodeManager = deps.satisfyDependency(new NodeManager(graphDatabaseFacade, this.threadToTransactionBridge, relationshipTypeTokenHolder));
        NodeProxy.NodeActions nodeActions = deps.satisfyDependency(this.createNodeActions(graphDatabaseFacade, this.threadToTransactionBridge, this.nodeManager));
        RelationshipProxy.RelationshipActions relationshipActions = deps.satisfyDependency(this.createRelationshipActions(graphDatabaseFacade, this.threadToTransactionBridge, this.nodeManager, relationshipTypeTokenHolder));
        this.transactionEventHandlers = new TransactionEventHandlers(nodeActions, relationshipActions, this.threadToTransactionBridge);
        IndexConfigStore indexStore = (IndexConfigStore)life.add((Lifecycle)deps.satisfyDependency(new IndexConfigStore(storeDir, fileSystem)));
        diagnosticsManager.prependProvider(config);
        life.add(platformModule.kernelExtensions);
        this.schema = new SchemaImpl(this.threadToTransactionBridge);
        LegacyIndexProxy.Lookup indexLookup = new LegacyIndexProxy.Lookup(){

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return graphDatabaseFacade;
            }
        };
        IndexProviderImpl indexProvider = new IndexProviderImpl(indexLookup, this.threadToTransactionBridge);
        NodeAutoIndexerImpl nodeAutoIndexer = life.add(new NodeAutoIndexerImpl(config, indexProvider, this.nodeManager));
        RelationshipAutoIndexer relAutoIndexer = life.add(new RelationshipAutoIndexerImpl(config, indexProvider, this.nodeManager));
        this.indexManager = new IndexManagerImpl(this.threadToTransactionBridge, indexProvider, nodeAutoIndexer, relAutoIndexer);
        PageCache pageCache = platformModule.pageCache;
        StoreFactory storeFactory = new StoreFactory(storeDir, config, editionModule.idGeneratorFactory, pageCache, fileSystem, logging.getInternalLogProvider());
        StartupStatisticsProvider startupStatistics = deps.satisfyDependency(new StartupStatisticsProvider());
        SchemaWriteGuard schemaWriteGuard = deps.satisfyDependency(editionModule.schemaWriteGuard);
        StoreUpgrader storeMigrationProcess = new StoreUpgrader(editionModule.upgradeConfiguration, fileSystem, platformModule.monitors.newMonitor(StoreUpgrader.Monitor.class, new String[0]), logging.getInternalLogProvider());
        VisibleMigrationProgressMonitor progressMonitor = new VisibleMigrationProgressMonitor(logging.getInternalLog(StoreMigrator.class));
        storeMigrationProcess.addParticipant(new StoreMigrator(progressMonitor, fileSystem, pageCache, config, logging));
        Guard guard = config.get(GraphDatabaseFacadeFactory.Configuration.execution_guard_enabled) != false ? deps.satisfyDependency(new Guard(logging.getInternalLog(Guard.class))) : null;
        this.kernelEventHandlers = new KernelEventHandlers(logging.getInternalLog(KernelEventHandlers.class));
        KernelPanicEventGenerator kernelPanicEventGenerator = deps.satisfyDependency(new KernelPanicEventGenerator(this.kernelEventHandlers));
        KernelHealth kernelHealth = deps.satisfyDependency(new KernelHealth(kernelPanicEventGenerator, logging.getInternalLog(KernelHealth.class)));
        this.neoStoreDataSource = deps.satisfyDependency(new NeoStoreDataSource(storeDir, config, storeFactory, logging.getInternalLogProvider(), platformModule.jobScheduler, new NonTransactionalTokenNameLookup(editionModule.labelTokenHolder, editionModule.relationshipTypeTokenHolder, editionModule.propertyKeyTokenHolder), deps, editionModule.propertyKeyTokenHolder, editionModule.labelTokenHolder, relationshipTypeTokenHolder, editionModule.lockManager, schemaWriteGuard, this.transactionEventHandlers, platformModule.monitors.newMonitor(IndexingService.Monitor.class, new String[0]), fileSystem, storeMigrationProcess, platformModule.transactionMonitor, kernelHealth, platformModule.monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), editionModule.headerInformationFactory, startupStatistics, this.nodeManager, guard, indexStore, editionModule.commitProcessFactory, pageCache, editionModule.constraintSemantics, platformModule.monitors, platformModule.tracers, editionModule.idGeneratorFactory));
        dataSourceManager.register(this.neoStoreDataSource);
        life.add(new MonitorGc(config, logging.getInternalLog(MonitorGc.class)));
        life.add(this.nodeManager);
        life.add(new DatabaseAvailability(platformModule.availabilityGuard, platformModule.transactionMonitor));
        life.add(new StartupWaiter(platformModule.availabilityGuard, editionModule.transactionStartTimeout));
        life.add(this.kernelEventHandlers);
        final AtomicReference<QueryExecutionEngine> queryExecutor = new AtomicReference<QueryExecutionEngine>(QueryEngineProvider.noEngine());
        dataSourceManager.addListener(new DataSourceManager.Listener(){
            private QueryExecutionEngine engine;

            @Override
            public void registered(NeoStoreDataSource dataSource) {
                if (this.engine == null) {
                    this.engine = QueryEngineProvider.initialize(platformModule.graphDatabaseFacade, dependencies.executionEngines());
                    deps.satisfyDependency(this.engine);
                }
                queryExecutor.set(this.engine);
            }

            @Override
            public void unregistered(NeoStoreDataSource dataSource) {
                queryExecutor.set(QueryEngineProvider.noEngine());
            }
        });
        this.storeId = new Supplier<StoreId>(){

            public StoreId get() {
                return DataSourceModule.this.neoStoreDataSource.getStoreId();
            }
        };
        this.kernelAPI = new Supplier<KernelAPI>(){

            public KernelAPI get() {
                return DataSourceModule.this.neoStoreDataSource.getKernel();
            }
        };
        this.queryExecutor = new Supplier<QueryExecutionEngine>(){

            public QueryExecutionEngine get() {
                return (QueryExecutionEngine)queryExecutor.get();
            }
        };
    }

    protected RelationshipProxy.RelationshipActions createRelationshipActions(final GraphDatabaseService graphDatabaseService, final ThreadToStatementContextBridge threadToStatementContextBridge, final NodeManager nodeManager, final RelationshipTypeTokenHolder relationshipTypeTokenHolder) {
        return new RelationshipProxy.RelationshipActions(){

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return graphDatabaseService;
            }

            @Override
            public void failTransaction() {
                threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public void assertInUnterminatedTransaction() {
                threadToStatementContextBridge.assertInUnterminatedTransaction();
            }

            @Override
            public Statement statement() {
                return threadToStatementContextBridge.get();
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return nodeManager.newNodeProxyById(nodeId);
            }

            @Override
            public RelationshipType getRelationshipTypeById(int type) {
                try {
                    return (RelationshipType)relationshipTypeTokenHolder.getTokenById(type);
                }
                catch (TokenNotFoundException e) {
                    throw new NotFoundException(e);
                }
            }
        };
    }

    protected NodeProxy.NodeActions createNodeActions(final GraphDatabaseService graphDatabaseService, final ThreadToStatementContextBridge threadToStatementContextBridge, final NodeManager nodeManager) {
        return new NodeProxy.NodeActions(){

            @Override
            public Statement statement() {
                return threadToStatementContextBridge.get();
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return graphDatabaseService;
            }

            @Override
            public void assertInUnterminatedTransaction() {
                threadToStatementContextBridge.assertInUnterminatedTransaction();
            }

            @Override
            public void failTransaction() {
                threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public Relationship lazyRelationshipProxy(long id) {
                return nodeManager.newRelationshipProxyById(id);
            }

            @Override
            public Relationship newRelationshipProxy(long id) {
                return nodeManager.newRelationshipProxy(id);
            }

            @Override
            public Relationship newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
                return nodeManager.newRelationshipProxy(id, startNodeId, typeId, endNodeId);
            }
        };
    }

    private static class StartupWaiter
    extends LifecycleAdapter {
        private final AvailabilityGuard availabilityGuard;
        private final long timeout;

        public StartupWaiter(AvailabilityGuard availabilityGuard, long timeout) {
            this.availabilityGuard = availabilityGuard;
            this.timeout = timeout;
        }

        @Override
        public void start() throws Throwable {
            this.availabilityGuard.isAvailable(this.timeout);
        }
    }
}

