/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Collection;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

public class DirectRecordAccessSet
implements RecordAccessSet {
    private final DirectRecordAccess<Long, NodeRecord, Void> nodeRecords;
    private final DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord> propertyRecords;
    private final DirectRecordAccess<Long, RelationshipRecord, Void> relationshipRecords;
    private final DirectRecordAccess<Long, RelationshipGroupRecord, Integer> relationshipGroupRecords;
    private final DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenRecords;
    private final DirectRecordAccess<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenRecords;
    private final DirectRecordAccess<Integer, LabelTokenRecord, Void> labelTokenRecords;

    public DirectRecordAccessSet(NeoStores neoStores) {
        NodeStore nodeStore = neoStores.getNodeStore();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RelationshipGroupStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
        PropertyKeyTokenStore propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        RelationshipTypeTokenStore relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        LabelTokenStore labelTokenStore = neoStores.getLabelTokenStore();
        this.nodeRecords = new DirectRecordAccess<Long, NodeRecord, Void>(nodeStore, Loaders.nodeLoader(nodeStore));
        this.propertyRecords = new DirectRecordAccess<Long, PropertyRecord, PrimitiveRecord>(propertyStore, Loaders.propertyLoader(propertyStore));
        this.relationshipRecords = new DirectRecordAccess<Long, RelationshipRecord, Void>(relationshipStore, Loaders.relationshipLoader(relationshipStore));
        this.relationshipGroupRecords = new DirectRecordAccess<Long, RelationshipGroupRecord, Integer>(relationshipGroupStore, Loaders.relationshipGroupLoader(relationshipGroupStore));
        this.propertyKeyTokenRecords = new DirectRecordAccess<Integer, PropertyKeyTokenRecord, Void>(propertyKeyTokenStore, Loaders.propertyKeyTokenLoader(propertyKeyTokenStore));
        this.relationshipTypeTokenRecords = new DirectRecordAccess<Integer, RelationshipTypeTokenRecord, Void>(relationshipTypeTokenStore, Loaders.relationshipTypeTokenLoader(relationshipTypeTokenStore));
        this.labelTokenRecords = new DirectRecordAccess<Integer, LabelTokenRecord, Void>(labelTokenStore, Loaders.labelTokenLoader(labelTokenStore));
    }

    @Override
    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.nodeRecords;
    }

    @Override
    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.propertyRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.relationshipRecords;
    }

    @Override
    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.relationshipGroupRecords;
    }

    @Override
    public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        throw new UnsupportedOperationException("Not needed. Implement if needed");
    }

    @Override
    public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
        return this.propertyKeyTokenRecords;
    }

    @Override
    public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenChanges() {
        return this.labelTokenRecords;
    }

    @Override
    public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
        return this.relationshipTypeTokenRecords;
    }

    @Override
    public void close() {
        this.commit();
        this.nodeRecords.close();
        this.propertyRecords.close();
        this.relationshipRecords.close();
        this.relationshipGroupRecords.close();
        this.relationshipTypeTokenRecords.close();
        this.labelTokenRecords.close();
        this.propertyKeyTokenRecords.close();
    }

    public void commit() {
        this.nodeRecords.commit();
        this.propertyRecords.commit();
        this.relationshipGroupRecords.commit();
        this.relationshipRecords.commit();
        this.relationshipTypeTokenRecords.commit();
        this.labelTokenRecords.commit();
        this.propertyKeyTokenRecords.commit();
    }

    @Override
    public boolean hasChanges() {
        return this.nodeRecords.changeSize() > 0 || this.propertyRecords.changeSize() > 0 || this.relationshipRecords.changeSize() > 0 || this.relationshipGroupRecords.changeSize() > 0 || this.propertyKeyTokenRecords.changeSize() > 0 || this.labelTokenRecords.changeSize() > 0 || this.relationshipTypeTokenRecords.changeSize() > 0;
    }
}

