/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveIntIterable;
import org.neo4j.collection.primitive.PrimitiveIntIterator;

public class SimpleBitSet
implements PrimitiveIntIterable {
    private long[] data;

    public SimpleBitSet(int size) {
        int capacity;
        int initialCapacity = size / 64;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.data = new long[capacity];
    }

    public boolean contains(int key) {
        int idx = key >>> 6;
        return this.data.length > idx && (this.data[idx] & 1L << (key & 0x3F)) != 0L;
    }

    public void put(int key) {
        int idx = key >>> 6;
        this.ensureCapacity(idx);
        this.data[idx] = this.data[idx] | 1L << (key & 0x3F);
    }

    public void put(SimpleBitSet other) {
        this.ensureCapacity(other.data.length - 1);
        for (int i = 0; i < this.data.length && i < other.data.length; ++i) {
            this.data[i] = this.data[i] | other.data[i];
        }
    }

    public void remove(int key) {
        int idx = key >>> 6;
        if (this.data.length > idx) {
            this.data[idx] = this.data[idx] & (1L << (key & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void remove(SimpleBitSet other) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] & (other.data[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0L;
        }
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.data.length; ++i) {
            size += Long.bitCount(this.data[i]);
        }
        return size;
    }

    private void ensureCapacity(int arrayIndex) {
        while (this.data.length <= arrayIndex) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
    }

    public PrimitiveIntIterator iterator() {
        return new PrimitiveIntIterator(){
            private int next = 0;
            private final int size = SimpleBitSet.access$000(SimpleBitSet.this).length * 64;
            {
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
            }

            public boolean hasNext() {
                return this.next < this.size;
            }

            public int next() {
                int current = this.next++;
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
                return current;
            }
        };
    }

    static /* synthetic */ long[] access$000(SimpleBitSet x0) {
        return x0.data;
    }
}

