/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;

public final class StatementTokenNameLookup
implements TokenNameLookup {
    private final ReadOperations statement;

    public StatementTokenNameLookup(ReadOperations statement) {
        this.statement = statement;
    }

    @Override
    public String labelGetName(int labelId) {
        try {
            return this.statement.labelGetName(labelId);
        }
        catch (LabelNotFoundKernelException e) {
            return "[" + labelId + "]";
        }
    }

    @Override
    public String relationshipTypeGetName(int relTypeId) {
        try {
            return this.statement.relationshipTypeGetName(relTypeId);
        }
        catch (RelationshipTypeIdNotFoundKernelException e) {
            return "[" + relTypeId + "]";
        }
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) {
        try {
            return this.statement.propertyKeyGetName(propertyKeyId);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            return "[" + propertyKeyId + "]";
        }
    }
}

