/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;

public class TransactionTemplate {
    private final GraphDatabaseService gds;
    private final Monitor monitor;
    private final int retries;
    private final long backoff;
    private final org.neo4j.function.Predicate<Throwable> retryPredicate;

    public TransactionTemplate() {
        this(null, (Monitor)new Monitor.Adapter(), 0, 0L, (org.neo4j.function.Predicate<Throwable>)org.neo4j.function.Predicates.not((org.neo4j.function.Predicate)org.neo4j.function.Predicates.any((org.neo4j.function.Predicate[])new org.neo4j.function.Predicate[]{org.neo4j.function.Predicates.instanceOf(Error.class), org.neo4j.function.Predicates.instanceOf(TransactionTerminatedException.class)})));
    }

    public TransactionTemplate(GraphDatabaseService gds, Monitor monitor, int retries, long backoff, Predicate<Throwable> retryPredicate) {
        this(gds, monitor, retries, backoff, Predicates.upgrade(retryPredicate));
    }

    public TransactionTemplate(GraphDatabaseService gds, Monitor monitor, int retries, long backoff, org.neo4j.function.Predicate<Throwable> retryPredicate) {
        this.gds = gds;
        this.monitor = monitor;
        this.retries = retries;
        this.backoff = backoff;
        this.retryPredicate = retryPredicate;
    }

    public TransactionTemplate with(GraphDatabaseService gds) {
        return new TransactionTemplate(gds, this.monitor, this.retries, this.backoff, this.retryPredicate);
    }

    public TransactionTemplate retries(int retries) {
        return new TransactionTemplate(this.gds, this.monitor, retries, this.backoff, this.retryPredicate);
    }

    public TransactionTemplate backoff(long backoff, TimeUnit unit) {
        return new TransactionTemplate(this.gds, this.monitor, this.retries, unit.toMillis(backoff), this.retryPredicate);
    }

    public TransactionTemplate monitor(Monitor monitor) {
        return new TransactionTemplate(this.gds, monitor, this.retries, this.backoff, this.retryPredicate);
    }

    @Deprecated
    public TransactionTemplate retryOn(Predicate<Throwable> retryPredicate) {
        return this.retryOn(Predicates.upgrade(retryPredicate));
    }

    public TransactionTemplate retryOn(org.neo4j.function.Predicate<Throwable> retryPredicate) {
        return new TransactionTemplate(this.gds, this.monitor, this.retries, this.backoff, retryPredicate);
    }

    public void execute(final Consumer<Transaction> txConsumer) {
        this.execute(new Function<Transaction, Object>(){

            public Object apply(Transaction transaction) {
                txConsumer.accept((Object)transaction);
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function<Transaction, T> txFunction) throws TransactionFailureException {
        Throwable txEx = null;
        for (int i = 0; i < this.retries; ++i) {
            try (Transaction tx = this.gds.beginTx();){
                Object result = txFunction.apply((Object)tx);
                tx.success();
                Object object = result;
                return (T)object;
            }
            catch (Throwable ex) {
                this.monitor.failure(ex);
                txEx = ex;
                if (!this.retryPredicate.test((Object)ex)) break;
                if (i >= this.retries - 1) continue;
                try {
                    Thread.sleep(this.backoff);
                }
                catch (InterruptedException e) {
                    throw new TransactionFailureException("Interrupted", e);
                }
                this.monitor.retrying();
                continue;
            }
        }
        if (txEx instanceof TransactionFailureException) {
            throw (TransactionFailureException)txEx;
        }
        if (txEx instanceof Error) {
            throw (Error)txEx;
        }
        if (!(txEx instanceof RuntimeException)) throw new TransactionFailureException("Failed", txEx);
        throw (RuntimeException)txEx;
    }

    public static interface Monitor {
        public void failure(Throwable var1);

        public void failed(Throwable var1);

        public void retrying();

        public static class Adapter
        implements Monitor {
            @Override
            public void failure(Throwable ex) {
            }

            @Override
            public void failed(Throwable ex) {
            }

            @Override
            public void retrying() {
            }
        }
    }
}

