/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import org.neo4j.helpers.collection.CloseableVisitor;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.state.RecoverableTransaction;

public class RecoveryVisitor
implements CloseableVisitor<RecoverableTransaction, IOException> {
    private final TransactionIdStore store;
    private final TransactionRepresentationStoreApplier storeApplier;
    private final IndexUpdatesValidator indexUpdatesValidator;
    private final Monitor monitor;
    private long lastTransactionIdApplied = -1L;
    private long lastTransactionChecksum;
    private LogPosition lastTransactionLogPosition;

    public RecoveryVisitor(TransactionIdStore store, TransactionRepresentationStoreApplier storeApplier, IndexUpdatesValidator indexUpdatesValidator, Monitor monitor) {
        this.store = store;
        this.storeApplier = storeApplier;
        this.indexUpdatesValidator = indexUpdatesValidator;
        this.monitor = monitor;
    }

    @Override
    public boolean visit(RecoverableTransaction transaction) throws IOException {
        CommittedTransactionRepresentation representation = transaction.representation();
        long txId = representation.getCommitEntry().getTxId();
        TransactionRepresentation txRepresentation = representation.getTransactionRepresentation();
        try (LockGroup locks = new LockGroup();
             ValidatedIndexUpdates indexUpdates = this.prepareIndexUpdates(txRepresentation);){
            this.storeApplier.apply(txRepresentation, indexUpdates, locks, txId, TransactionApplicationMode.RECOVERY);
        }
        this.lastTransactionIdApplied = txId;
        this.lastTransactionChecksum = LogEntryStart.checksum(representation.getStartEntry());
        this.lastTransactionLogPosition = transaction.positionAfterTx();
        this.monitor.transactionRecovered(txId);
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.lastTransactionIdApplied != -1L) {
            this.store.setLastCommittedAndClosedTransactionId(this.lastTransactionIdApplied, this.lastTransactionChecksum, this.lastTransactionLogPosition.getLogVersion(), this.lastTransactionLogPosition.getByteOffset());
        }
    }

    private ValidatedIndexUpdates prepareIndexUpdates(TransactionRepresentation txRepresentation) throws IOException {
        return this.indexUpdatesValidator.validate(txRepresentation);
    }

    public static interface Monitor {
        public void transactionRecovered(long var1);
    }
}

