/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class TransactionMetadataCache {
    private final LruCache<Long, TransactionMetadata> txStartPositionCache;
    private final LruCache<Long, Long> logHeaderCache;

    public TransactionMetadataCache(int headerCacheSize, int transactionCacheSize) {
        this.logHeaderCache = new LruCache("Log header cache", headerCacheSize);
        this.txStartPositionCache = new LruCache("Tx start position cache", transactionCacheSize);
    }

    public void clear() {
        this.logHeaderCache.clear();
        this.txStartPositionCache.clear();
    }

    public void putHeader(long logVersion, long previousLogLastCommittedTx) {
        this.logHeaderCache.put(logVersion, previousLogLastCommittedTx);
    }

    public long getLogHeader(long logVersion) {
        Long value = this.logHeaderCache.get(logVersion);
        return value == null ? -1L : value;
    }

    public TransactionMetadata getTransactionMetadata(long txId) {
        return this.txStartPositionCache.get(txId);
    }

    public TransactionMetadata cacheTransactionMetadata(long txId, LogPosition position, int masterId, int authorId, long checksum) {
        if (position.getByteOffset() == -1L) {
            throw new RuntimeException("StartEntry.position is " + position);
        }
        TransactionMetadata result = new TransactionMetadata(masterId, authorId, position, checksum);
        this.txStartPositionCache.put(txId, result);
        return result;
    }

    public static class TransactionMetadata {
        private final int masterId;
        private final int authorId;
        private final LogPosition startPosition;
        private final long checksum;

        public TransactionMetadata(int masterId, int authorId, LogPosition startPosition, long checksum) {
            this.masterId = masterId;
            this.authorId = authorId;
            this.startPosition = startPosition;
            this.checksum = checksum;
        }

        public int getMasterId() {
            return this.masterId;
        }

        public int getAuthorId() {
            return this.authorId;
        }

        public LogPosition getStartPosition() {
            return this.startPosition;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public String toString() {
            return "TransactionMetadata[masterId=" + this.masterId + ", authorId=" + this.authorId + ", startPosition=" + this.startPosition + ", checksum=" + this.checksum + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionMetadata that = (TransactionMetadata)o;
            if (this.authorId != that.authorId) {
                return false;
            }
            if (this.checksum != that.checksum) {
                return false;
            }
            if (this.masterId != that.masterId) {
                return false;
            }
            return this.startPosition.equals(that.startPosition);
        }

        public int hashCode() {
            int result = this.masterId;
            result = 31 * result + this.authorId;
            result = 31 * result + this.startPosition.hashCode();
            result = 31 * result + (int)(this.checksum ^ this.checksum >>> 32);
            return result;
        }
    }
}

