/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.util.ArrayMap;

class BatchTokenHolder {
    private final ArrayMap<String, Token> nameToToken = new ArrayMap(5, false, false);
    private final PrimitiveIntObjectMap<Token> idToToken = Primitive.intObjectMap((int)20);

    BatchTokenHolder(List<? extends Token> tokens) {
        for (Token token : tokens) {
            this.addToken(token);
        }
    }

    void addToken(Token token) {
        this.nameToToken.put(token.name(), token);
        this.idToToken.put(token.id(), (Object)token);
    }

    Token byId(int id) {
        return (Token)this.idToToken.get(id);
    }

    Token byName(String name) {
        return this.nameToToken.get(name);
    }
}

