/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyDeleter;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.RecordChangeSet;
import org.neo4j.kernel.impl.transaction.state.RelationshipCreator;
import org.neo4j.kernel.impl.transaction.state.RelationshipDeleter;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;

public class NeoStoreTransactionContext {
    private RelationshipCreator relationshipCreator;
    private RelationshipDeleter relationshipDeleter;
    private final PropertyCreator propertyCreator;
    private final PropertyDeleter propertyDeleter;
    private final RecordAccessSet recordChangeSet;
    private final NeoStores neoStores;

    public NeoStoreTransactionContext(NeoStores neoStores) {
        this.neoStores = neoStores;
        this.recordChangeSet = new RecordChangeSet(neoStores);
        PropertyTraverser propertyTraverser = new PropertyTraverser();
        this.propertyCreator = new PropertyCreator(neoStores.getPropertyStore(), propertyTraverser);
        this.propertyDeleter = new PropertyDeleter(neoStores.getPropertyStore(), propertyTraverser);
    }

    public void init(Locks.Client locksClient) {
        RelationshipGroupStore relationshipGroupStore = this.neoStores.getRelationshipGroupStore();
        RelationshipGroupGetter relGroupGetter = new RelationshipGroupGetter(relationshipGroupStore);
        this.relationshipCreator = new RelationshipCreator(locksClient, relGroupGetter, relationshipGroupStore.getDenseNodeThreshold());
        this.relationshipDeleter = new RelationshipDeleter(locksClient, relGroupGetter, this.propertyDeleter);
    }

    public void relationshipDelete(long relId) {
        this.relationshipDeleter.relDelete(relId, this.recordChangeSet);
    }

    public void relationshipCreate(long id, int typeId, long startNodeId, long endNodeId) {
        this.relationshipCreator.relationshipCreate(id, typeId, startNodeId, endNodeId, this.recordChangeSet);
    }

    public void getAndDeletePropertyChain(NodeRecord nodeRecord) {
        this.propertyDeleter.deletePropertyChain(nodeRecord, this.recordChangeSet.getPropertyRecords());
    }

    public <T extends PrimitiveRecord> void removeProperty(RecordAccess.RecordProxy<Long, T, Void> primitiveProxy, int propertyKey) {
        this.propertyDeleter.removeProperty(primitiveProxy, propertyKey, this.getPropertyRecords());
    }

    public <P extends PrimitiveRecord> void primitiveSetProperty(RecordAccess.RecordProxy<Long, P, Void> primitive, int propertyKey, Object value) {
        this.propertyCreator.primitiveSetProperty(primitive, propertyKey, value, this.getPropertyRecords());
    }

    public void createPropertyKeyToken(String name, int id) {
        TokenCreator<PropertyKeyTokenRecord, Token> creator = new TokenCreator<PropertyKeyTokenRecord, Token>(this.neoStores.getPropertyKeyTokenStore());
        creator.createToken(name, id, this.getPropertyKeyTokenRecords());
    }

    public void createLabelToken(String name, int id) {
        TokenCreator<LabelTokenRecord, Token> creator = new TokenCreator<LabelTokenRecord, Token>(this.neoStores.getLabelTokenStore());
        creator.createToken(name, id, this.getLabelTokenRecords());
    }

    public void createRelationshipTypeToken(String name, int id) {
        TokenCreator<RelationshipTypeTokenRecord, RelationshipTypeToken> creator = new TokenCreator<RelationshipTypeTokenRecord, RelationshipTypeToken>(this.neoStores.getRelationshipTypeTokenStore());
        creator.createToken(name, id, this.getRelationshipTypeTokenRecords());
    }

    public void clear() {
        this.recordChangeSet.close();
        this.relationshipCreator = null;
        this.relationshipDeleter = null;
    }

    public RecordAccess<Long, NodeRecord, Void> getNodeRecords() {
        return this.recordChangeSet.getNodeRecords();
    }

    public RecordAccess<Long, RelationshipRecord, Void> getRelRecords() {
        return this.recordChangeSet.getRelRecords();
    }

    public RecordAccess<Long, Collection<DynamicRecord>, SchemaRule> getSchemaRuleChanges() {
        return this.recordChangeSet.getSchemaRuleChanges();
    }

    public RecordAccess<Long, PropertyRecord, PrimitiveRecord> getPropertyRecords() {
        return this.recordChangeSet.getPropertyRecords();
    }

    public RecordAccess<Long, RelationshipGroupRecord, Integer> getRelGroupRecords() {
        return this.recordChangeSet.getRelGroupRecords();
    }

    public RecordAccess<Integer, PropertyKeyTokenRecord, Void> getPropertyKeyTokenRecords() {
        return this.recordChangeSet.getPropertyKeyTokenChanges();
    }

    public RecordAccess<Integer, LabelTokenRecord, Void> getLabelTokenRecords() {
        return this.recordChangeSet.getLabelTokenChanges();
    }

    public RecordAccess<Integer, RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenRecords() {
        return this.recordChangeSet.getRelationshipTypeTokenChanges();
    }

    public RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> getRelationshipGroup(NodeRecord node, int type) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy<Long, RelationshipGroupRecord, Integer> change = this.recordChangeSet.getRelGroupRecords().getOrLoad(groupId, type);
            RelationshipGroupRecord record = change.forReadingData();
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return change;
            }
            previousGroupId = groupId;
            groupId = record.getNext();
        }
        return null;
    }

    public boolean hasChanges() {
        return this.recordChangeSet.hasChanges();
    }
}

