/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.function.Predicate;
import org.neo4j.helpers.Exceptions;

public class DebugUtil {
    public static void printShortStackTrace(Throwable cause, int maxNumberOfStackLines) {
        System.out.println(DebugUtil.firstLinesOf(Exceptions.stringify(cause), maxNumberOfStackLines + 1));
    }

    public static String firstLinesOf(String string, int maxNumberOfLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(string));
            String line = null;
            for (int count = 0; (line = reader.readLine()) != null && count < maxNumberOfLines; ++count) {
                writer.println(line);
            }
            writer.close();
            return stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen", e);
        }
    }

    public static boolean currentStackTraceContains(Predicate<StackTraceElement> predicate) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!predicate.test((Object)element)) continue;
            return true;
        }
        return false;
    }

    public static Predicate<StackTraceElement> classNameIs(final String className) {
        return new Predicate<StackTraceElement>(){

            public boolean test(StackTraceElement item) {
                return item.getClassName().equals(className);
            }
        };
    }

    public static Predicate<StackTraceElement> classNameContains(final String classNamePart) {
        return new Predicate<StackTraceElement>(){

            public boolean test(StackTraceElement item) {
                return item.getClassName().contains(classNamePart);
            }
        };
    }

    public static Predicate<StackTraceElement> classIs(final Class<?> cls) {
        return new Predicate<StackTraceElement>(){

            public boolean test(StackTraceElement item) {
                return item.getClassName().equals(cls.getName());
            }
        };
    }

    public static Predicate<StackTraceElement> classNameAndMethodAre(final String className, final String methodName) {
        return new Predicate<StackTraceElement>(){

            public boolean test(StackTraceElement item) {
                return item.getClassName().equals(className) && item.getMethodName().equals(methodName);
            }
        };
    }

    public static Predicate<StackTraceElement> classAndMethodAre(final Class<?> cls, final String methodName) {
        return new Predicate<StackTraceElement>(){

            public boolean test(StackTraceElement item) {
                return item.getClassName().equals(cls.getName()) && item.getMethodName().equals(methodName);
            }
        };
    }

    public static void dumpThreads(PrintStream out) {
        for (Map.Entry<Thread, StackTraceElement[]> stack : Thread.getAllStackTraces().entrySet()) {
            out.println(new CallStack(stack.getValue(), "Thread: " + stack.getKey()));
        }
    }

    public static String trackTest() {
        boolean track = false;
        if (!$assertionsDisabled) {
            track = true;
            if (!true) {
                throw new AssertionError((Object)"A trick to set this variable to true if assertions are enabled");
            }
        }
        if (track) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                try {
                    String className = element.getClassName();
                    Class<?> cls = Class.forName(className);
                    Method method = cls.getDeclaredMethod(element.getMethodName(), new Class[0]);
                    if (!Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && DebugUtil.hasTestAnnotation(method)) {
                        return " @ " + DebugUtil.simpleClassName(className) + "#" + element.getMethodName();
                    }
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    private static String simpleClassName(String className) {
        return className.indexOf(46) == -1 ? className : className.substring(className.lastIndexOf(46) + 1);
    }

    private static boolean hasTestAnnotation(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!annotation.annotationType().getSimpleName().equals("Test")) continue;
            return true;
        }
        return false;
    }

    public static class CallCounter<T> {
        private final Map<T, AtomicInteger> calls = new HashMap<T, AtomicInteger>();
        private final String name;

        public CallCounter(String name) {
            this.name = name;
        }

        public CallCounter<T> printAtShutdown(final PrintStream out) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    CallCounter.this.print(out);
                }
            });
            return this;
        }

        public void inc(T key) {
            AtomicInteger count = this.calls.get(key);
            if (count == null) {
                count = new AtomicInteger();
                this.calls.put(key, count);
            }
            count.incrementAndGet();
        }

        private void print(PrintStream out) {
            out.println("Calls made regarding " + this.name + ":");
            for (Map.Entry<T, AtomicInteger> entry : this.calls.entrySet()) {
                out.println("\t" + entry.getKey() + ": " + entry.getValue());
            }
        }
    }

    public static class CallStack {
        private final String message;
        private final Throwable stackTrace;
        private final StackTraceElement[] elements;
        private final boolean considerMessage;

        public CallStack(Throwable stackTrace, boolean considerMessage) {
            this.message = stackTrace.getMessage();
            this.stackTrace = stackTrace;
            this.considerMessage = considerMessage;
            this.elements = stackTrace.getStackTrace();
        }

        public CallStack(StackTraceElement[] elements, String message) {
            this.message = message;
            this.stackTrace = null;
            this.elements = elements;
            this.considerMessage = true;
        }

        public int hashCode() {
            int hashCode = this.message == null || !this.considerMessage ? 31 : this.message.hashCode();
            for (StackTraceElement element : this.elements) {
                hashCode = hashCode * 9 + element.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            CallStack o = (CallStack)obj;
            if (this.considerMessage && (this.message == null ? o.message != null : !this.message.equals(o.message))) {
                return false;
            }
            if (this.elements.length != o.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(o.elements[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.stackTrace != null ? this.stackTrace.getClass().getName() + ": " : "").append(this.message != null ? this.message : "");
            for (StackTraceElement element : this.elements) {
                builder.append(String.format("%n", new Object[0])).append("    at ").append(element.toString());
            }
            return builder.toString();
        }
    }

    public static class StackTracer {
        private final Map<CallStack, AtomicInteger> uniqueStackTraces = new HashMap<CallStack, AtomicInteger>();
        private boolean considerMessages = true;

        public AtomicInteger add(Throwable t) {
            CallStack key = new CallStack(t, this.considerMessages);
            AtomicInteger count = this.uniqueStackTraces.get(key);
            if (count == null) {
                count = new AtomicInteger();
                this.uniqueStackTraces.put(key, count);
            }
            count.incrementAndGet();
            return count;
        }

        public void print(PrintStream out, int interestThreshold) {
            System.out.println("Printing stack trace counts:");
            long total = 0L;
            for (Map.Entry<CallStack, AtomicInteger> entry : this.uniqueStackTraces.entrySet()) {
                if (entry.getValue().get() >= interestThreshold) {
                    out.println(entry.getValue() + " times:");
                    entry.getKey().stackTrace.printStackTrace(out);
                }
                total += (long)entry.getValue().get();
            }
            out.println("------");
            out.println("Total:" + total);
        }

        public StackTracer printAtShutdown(final PrintStream out, final int interestThreshold) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StackTracer.this.print(out, interestThreshold);
                }
            });
            return this;
        }

        public StackTracer ignoreMessages() {
            this.considerMessages = false;
            return this;
        }
    }
}

