/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreIdIterator;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.register.Register;

public class NeoStoreIndexStoreView
implements IndexStoreView {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;
    private final LockService locks;
    private final CountsTracker counts;

    public NeoStoreIndexStoreView(LockService locks, NeoStores neoStores) {
        this.locks = locks;
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.counts = neoStores.getCounts();
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(IndexDescriptor descriptor, Register.DoubleLongRegister output) {
        return this.counts.indexUpdatesAndSize(descriptor.getLabelId(), descriptor.getPropertyKeyId(), output);
    }

    @Override
    public void replaceIndexCounts(IndexDescriptor descriptor, long uniqueElements, long maxUniqueElements, long indexSize) {
        int labelId = descriptor.getLabelId();
        int propertyKeyId = descriptor.getPropertyKeyId();
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.replaceIndexSample(labelId, propertyKeyId, uniqueElements, maxUniqueElements);
            updater.replaceIndexUpdateAndSize(labelId, propertyKeyId, 0L, indexSize);
        }
    }

    @Override
    public void incrementIndexUpdates(IndexDescriptor descriptor, long updatesDelta) {
        try (CountsAccessor.IndexStatsUpdater updater = this.counts.updateIndexCounts();){
            updater.incrementIndexUpdates(descriptor.getLabelId(), descriptor.getPropertyKeyId(), updatesDelta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexSample(IndexDescriptor descriptor, Register.DoubleLongRegister output) {
        return this.counts.indexSample(descriptor.getLabelId(), descriptor.getPropertyKeyId(), output);
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodesWithPropertyAndLabel(IndexDescriptor descriptor, final Visitor<NodePropertyUpdate, FAILURE> visitor) {
        final int soughtLabelId = descriptor.getLabelId();
        final int soughtPropertyKeyId = descriptor.getPropertyKeyId();
        return new NodeStoreScan<NodePropertyUpdate, FAILURE>(){

            @Override
            protected NodePropertyUpdate read(NodeRecord node) {
                long[] labels = NodeLabelsField.parseLabelsField(node).get(NeoStoreIndexStoreView.this.nodeStore);
                if (!NeoStoreIndexStoreView.containsLabel(soughtLabelId, labels)) {
                    return null;
                }
                for (PropertyBlock property : NeoStoreIndexStoreView.this.properties(node)) {
                    int propertyKeyId = property.getKeyIndexId();
                    if (soughtPropertyKeyId != propertyKeyId) continue;
                    return NodePropertyUpdate.add(node.getId(), propertyKeyId, NeoStoreIndexStoreView.this.valueOf(property), labels);
                }
                return null;
            }

            @Override
            protected void process(NodePropertyUpdate update) throws Exception {
                visitor.visit(update);
            }
        };
    }

    @Override
    public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(final int[] labelIds, final int[] propertyKeyIds, final Visitor<NodePropertyUpdate, FAILURE> propertyUpdateVisitor, final Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor) {
        return new NodeStoreScan<Update, FAILURE>(){

            @Override
            protected Update read(NodeRecord node) {
                long[] labels = NodeLabelsField.parseLabelsField(node).get(NeoStoreIndexStoreView.this.nodeStore);
                Update update = new Update(node.getId(), labels);
                if (!NeoStoreIndexStoreView.containsAnyLabel(labelIds, labels)) {
                    return update;
                }
                block0: for (PropertyBlock property : NeoStoreIndexStoreView.this.properties(node)) {
                    int propertyKeyId = property.getKeyIndexId();
                    for (int sought : propertyKeyIds) {
                        if (propertyKeyId != sought) continue;
                        update.add(NodePropertyUpdate.add(node.getId(), propertyKeyId, NeoStoreIndexStoreView.this.valueOf(property), labels));
                        continue block0;
                    }
                }
                return update;
            }

            @Override
            protected void process(Update update) throws Exception {
                labelUpdateVisitor.visit(update.labels);
                for (NodePropertyUpdate propertyUpdate : update) {
                    propertyUpdateVisitor.visit(propertyUpdate);
                }
            }
        };
    }

    @Override
    public Iterable<NodePropertyUpdate> nodeAsUpdates(long nodeId) {
        NodeRecord node = this.nodeStore.forceGetRecord(nodeId);
        if (!node.inUse()) {
            return Iterables.empty();
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return Iterables.empty();
        }
        long[] labels = NodeLabelsField.parseLabelsField(node).get(this.nodeStore);
        if (labels.length == 0) {
            return Iterables.empty();
        }
        ArrayList<NodePropertyUpdate> updates = new ArrayList<NodePropertyUpdate>();
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            for (PropertyBlock property : propertyRecord) {
                Object value = property.getType().getValue(property, this.propertyStore);
                updates.add(NodePropertyUpdate.add(node.getId(), property.getKeyIndexId(), value, labels));
            }
        }
        return updates;
    }

    @Override
    public Property getProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException, PropertyNotFoundException {
        NodeRecord node = this.nodeStore.forceGetRecord(nodeId);
        if (!node.inUse()) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        long firstPropertyId = node.getNextProp();
        if (firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            throw new PropertyNotFoundException(propertyKeyId, EntityType.NODE, nodeId);
        }
        for (PropertyRecord propertyRecord : this.propertyStore.getPropertyRecordChain(firstPropertyId)) {
            PropertyBlock propertyBlock = propertyRecord.getPropertyBlock(propertyKeyId);
            if (propertyBlock == null) continue;
            return propertyBlock.newPropertyData(this.propertyStore);
        }
        throw new PropertyNotFoundException(propertyKeyId, EntityType.NODE, nodeId);
    }

    private Object valueOf(PropertyBlock property) {
        this.propertyStore.ensureHeavy(property);
        return property.getType().getValue(property, this.propertyStore);
    }

    private Iterable<PropertyBlock> properties(final NodeRecord node) {
        return new Iterable<PropertyBlock>(){

            @Override
            public Iterator<PropertyBlock> iterator() {
                return new PropertyBlockIterator(node);
            }
        };
    }

    private static boolean containsLabel(int sought, long[] labels) {
        for (long label : labels) {
            if (label != (long)sought) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAnyLabel(int[] soughtIds, long[] labels) {
        for (int soughtId : soughtIds) {
            if (!NeoStoreIndexStoreView.containsLabel(soughtId, labels)) continue;
            return true;
        }
        return false;
    }

    private abstract class NodeStoreScan<RESULT, FAILURE extends Exception>
    implements StoreScan<FAILURE> {
        private volatile boolean continueScanning;

        private NodeStoreScan() {
        }

        protected abstract RESULT read(NodeRecord var1);

        protected abstract void process(RESULT var1) throws FAILURE;

        @Override
        public void run() throws FAILURE {
            StoreIdIterator nodeIds = new StoreIdIterator(NeoStoreIndexStoreView.this.nodeStore);
            this.continueScanning = true;
            while (this.continueScanning && nodeIds.hasNext()) {
                long id = nodeIds.next();
                RESULT result = null;
                try (Lock ignored = NeoStoreIndexStoreView.this.locks.acquireNodeLock(id, LockService.LockType.READ_LOCK);){
                    NodeRecord record = NeoStoreIndexStoreView.this.nodeStore.forceGetRecord(id);
                    if (record.inUse()) {
                        result = this.read(record);
                    }
                }
                if (result == null) continue;
                this.process(result);
            }
        }

        @Override
        public void stop() {
            this.continueScanning = false;
        }
    }

    private class PropertyBlockIterator
    extends PrefetchingIterator<PropertyBlock> {
        private final Iterator<PropertyRecord> records;
        private Iterator<PropertyBlock> blocks = IteratorUtil.emptyIterator();

        PropertyBlockIterator(NodeRecord node) {
            long firstPropertyId = node.getNextProp();
            this.records = firstPropertyId == (long)Record.NO_NEXT_PROPERTY.intValue() ? IteratorUtil.emptyIterator() : NeoStoreIndexStoreView.this.propertyStore.getPropertyRecordChain(firstPropertyId).iterator();
        }

        @Override
        protected PropertyBlock fetchNextOrNull() {
            while (!this.blocks.hasNext()) {
                if (!this.records.hasNext()) {
                    return null;
                }
                this.blocks = this.records.next().iterator();
            }
            return this.blocks.next();
        }
    }

    private static class Update
    implements Iterable<NodePropertyUpdate> {
        private final NodeLabelUpdate labels;
        private final List<NodePropertyUpdate> propertyUpdates = new ArrayList<NodePropertyUpdate>();

        Update(long nodeId, long[] labels) {
            this.labels = NodeLabelUpdate.labelChanges(nodeId, PrimitiveLongCollections.EMPTY_LONG_ARRAY, labels);
        }

        void add(NodePropertyUpdate update) {
            this.propertyUpdates.add(update);
        }

        @Override
        public Iterator<NodePropertyUpdate> iterator() {
            return this.propertyUpdates.iterator();
        }
    }
}

