/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreMigratorCheckPointer;
import org.neo4j.kernel.impl.storemigration.StoreSourceTraceability;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.PropertyDeduplicator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.input.SourceInputIterator;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class StoreMigrator
implements StoreMigrationParticipant {
    private static final String UTF8 = Charsets.UTF_8.name();
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    private final MigrationProgressMonitor progressMonitor;
    private final Config config;
    private final LogService logService;
    private final LegacyLogs legacyLogs;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private Log log;

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService) {
        this(progressMonitor, fileSystem, pageCache, config, logService, new LegacyLogs(fileSystem));
    }

    StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, LegacyLogs legacyLogs) {
        this.progressMonitor = progressMonitor;
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.legacyLogs = legacyLogs;
        this.log = logService.getInternalLog(StoreMigrator.class);
    }

    @Override
    public void migrate(File storeDir, File migrationDir, SchemaIndexProvider schemaIndexProvider, String versionToMigrateFrom) throws IOException {
        this.progressMonitor.started();
        File neoStore = new File(storeDir, "neostore");
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, storeDir, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, storeDir, lastTxId);
        this.writeLastTxInformation(migrationDir, lastTxInfo);
        this.writeLastTxLogPosition(migrationDir, lastTxLogPosition);
        switch (versionToMigrateFrom) {
            case "v0.A.5": {
                break;
            }
            case "v0.A.3": {
                this.removeDuplicateEntityProperties(storeDir, migrationDir, this.pageCache, schemaIndexProvider, "v0.A.3");
                break;
            }
            case "v0.A.1": 
            case "v0.A.0": {
                this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), this.pageCache, versionToMigrateFrom);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + versionToMigrateFrom);
            }
        }
        this.progressMonitor.finished();
    }

    void writeLastTxInformation(File migrationDir, TransactionId txInfo) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(File migrationDir, LogPosition lastTxLogPosition) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), 3);
        return new TransactionId(counters[0], counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, File file, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(file, UTF8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, File file, int numberOfCounters) throws IOException {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, UTF8));){
            String line = reader.readLine();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static File lastTxInformationFile(File migrationDir) {
        return new File(migrationDir, "lastxinformation");
    }

    private static File lastTxLogPositionFile(File migrationDir) {
        return new File(migrationDir, "lastxlogposition");
    }

    protected TransactionId extractTransactionIdInformation(File neoStore, File storeDir, long txId) throws IOException {
        long checksum = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP);
        if (checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(txId, checksum, commitTimestamp);
        }
        try {
            return this.legacyLogs.getTransactionInformation(storeDir, txId);
        }
        catch (IOException ioe) {
            this.log.error("Extraction of transaction " + txId + " from legacy logs failed.", (Throwable)ioe);
            return txId == 1L ? new TransactionId(txId, 0L, 0L) : new TransactionId(txId, 1L, 1L);
        }
    }

    private LogPosition extractTransactionLogPosition(File neoStore, File storeDir, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDir, this.fileSystem);
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getLogFileForVersion(logVersion));
        return new LogPosition(logVersion, offset);
    }

    private void removeDuplicateEntityProperties(File storeDir, File migrationDir, PageCache pageCache, SchemaIndexProvider schemaIndexProvider, String versionToUpgradeFrom) throws IOException {
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_ARRAY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.NODE_STORE, StoreFile.NODE_LABEL_STORE, StoreFile.SCHEMA_STORE), false, false, StoreFileType.STORE);
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Iterables.iterable(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.NODE_STORE), true, false, StoreFileType.ID);
        StoreFile.removeTrailers(versionToUpgradeFrom, this.fileSystem, migrationDir, pageCache.pageSize());
        new PropertyDeduplicator(this.fileSystem, migrationDir, pageCache, schemaIndexProvider).deduplicateProperties();
    }

    private void rebuildCountsFromScratch(File storeDir, long lastTxId, PageCache pageCache) throws IOException {
        File storeFileBase = new File(storeDir, "neostore.counts.db");
        StoreFactory storeFactory = new StoreFactory(this.fileSystem, storeDir, pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId);
                life.add(new CountsTracker(this.logService.getInternalLogProvider(), this.fileSystem, pageCache, this.config, storeFileBase).setInitializer(initializer));
            }
        }
    }

    private void migrateWithBatchImporter(File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, PageCache pageCache, String versionToUpgradeFrom) throws IOException {
        LegacyStore legacyStore;
        this.prepareBatchImportMigration(storeDir, migrationDir);
        switch (versionToUpgradeFrom) {
            case "v0.A.0": {
                legacyStore = new Legacy19Store(this.fileSystem, new File(storeDir, "neostore"));
                break;
            }
            case "v0.A.1": {
                legacyStore = new Legacy20Store(this.fileSystem, new File(storeDir, "neostore"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + versionToUpgradeFrom);
            }
        }
        Configuration.Overridden importConfig = new Configuration.Overridden(this.config);
        AdditionalInitialIds additionalInitialIds = this.readAdditionalIds(storeDir, lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
        ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsoluteFile(), this.fileSystem, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(this.migrationBatchImporterMonitor(legacyStore), importConfig), additionalInitialIds, this.config);
        InputIterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore);
        InputIterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore);
        File badFile = new File(storeDir, "bad.log");
        BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));
        importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), IdGenerators.fromInput(), true, Collectors.badCollector(badOutput, 0)));
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, Iterables.iterable(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE), true, false, StoreFileType.values());
        if (legacyStore instanceof Legacy19Store) {
            this.migratePropertyKeys((Legacy19Store)legacyStore, pageCache, migrationDir);
        }
        legacyStore.close();
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir) throws IOException {
        BatchingNeoStores.createStore(this.fileSystem, migrationDir.getPath(), this.config);
        Iterable<StoreFile> storeFiles = Iterables.iterable(StoreFile.NODE_LABEL_STORE);
        StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, storeFiles, true, false, StoreFileType.values());
    }

    private AdditionalInitialIds readAdditionalIds(File storeDir, final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) throws IOException {
        final int propertyKeyTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".propertystore.db.index");
        final int labelTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".labeltokenstore.db");
        final int relationshipTypeTokenHighId = this.readHighIdFromIdFileIfExists(storeDir, ".relationshiptypestore.db");
        return new AdditionalInitialIds(){

            @Override
            public int highRelationshipTypeTokenId() {
                return relationshipTypeTokenHighId;
            }

            @Override
            public int highPropertyKeyTokenId() {
                return propertyKeyTokenHighId;
            }

            @Override
            public int highLabelTokenId() {
                return labelTokenHighId;
            }

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private int readHighIdFromIdFileIfExists(File storeDir, String storeName) throws IOException {
        String file = StoreFileType.ID.augment(new File(storeDir, "neostore" + storeName).getPath());
        try {
            return (int)IdGeneratorImpl.readHighId(this.fileSystem, new File(file));
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private ExecutionMonitor migrationBatchImporterMonitor(LegacyStore legacyStore) {
        return new CoarseBoundedProgressExecutionMonitor(legacyStore.getNodeStoreReader().getMaxId(), legacyStore.getRelStoreReader().getMaxId()){

            @Override
            protected void percent(int percent) {
                StoreMigrator.this.progressMonitor.percentComplete(percent);
            }
        };
    }

    private StoreFactory storeFactory(PageCache pageCache, File migrationDir) {
        return new StoreFactory(migrationDir, new Config(), new DefaultIdGeneratorFactory(this.fileSystem), pageCache, this.fileSystem, (LogProvider)NullLogProvider.getInstance());
    }

    private void migratePropertyKeys(Legacy19Store legacyStore, PageCache pageCache, File migrationDir) throws IOException {
        Token[] tokens = legacyStore.getPropertyIndexReader().readTokens();
        if (this.containsAnyDuplicates(tokens)) {
            StoreFactory storeFactory = this.storeFactory(pageCache, migrationDir);
            try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
                PropertyStore propertyStore = neoStores.getPropertyStore();
                Map<Integer, Integer> propertyKeyTranslation = this.dedupAndWritePropertyKeyTokenStore(propertyStore, tokens);
                this.migratePropertyStore(legacyStore, propertyKeyTranslation, propertyStore);
            }
        }
    }

    private boolean containsAnyDuplicates(Token[] tokens) {
        HashSet<String> names = new HashSet<String>();
        for (Token token : tokens) {
            if (names.add(token.name())) continue;
            return true;
        }
        return false;
    }

    private Map<Integer, Integer> dedupAndWritePropertyKeyTokenStore(PropertyStore propertyStore, Token[] tokens) {
        PropertyKeyTokenStore keyTokenStore = propertyStore.getPropertyKeyTokenStore();
        HashMap<Integer, Integer> translations = new HashMap<Integer, Integer>();
        HashMap<String, Integer> createdTokens = new HashMap<String, Integer>();
        for (Token token : tokens) {
            Integer id = (Integer)createdTokens.get(token.name());
            if (id == null) {
                id = (int)keyTokenStore.nextId();
                PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
                Collection<DynamicRecord> nameRecords = keyTokenStore.allocateNameRecords(org.neo4j.helpers.UTF8.encode(token.name()));
                record.setNameId((int)IteratorUtil.first(nameRecords).getId());
                record.addNameRecords(nameRecords);
                record.setInUse(true);
                record.setCreated();
                keyTokenStore.updateRecord(record);
                createdTokens.put(token.name(), id);
            }
            translations.put(token.id(), id);
        }
        return translations;
    }

    private void migratePropertyStore(Legacy19Store legacyStore, Map<Integer, Integer> propertyKeyTranslation, PropertyStore propertyStore) throws IOException {
        long lastInUseId = -1L;
        for (PropertyRecord propertyRecord : IteratorUtil.loop(legacyStore.getPropertyStoreReader().readPropertyStore())) {
            for (PropertyBlock block : propertyRecord) {
                int key = block.getKeyIndexId();
                Integer translation = propertyKeyTranslation.get(key);
                if (translation == null) continue;
                block.setKeyIndexId(translation);
            }
            propertyStore.setHighId(propertyRecord.getId() + 1L);
            propertyStore.updateRecord(propertyRecord);
            for (long id = lastInUseId + 1L; id < propertyRecord.getId(); ++id) {
                propertyStore.freeId(id);
            }
            lastInUseId = propertyRecord.getId();
        }
    }

    private StoreFile[] allExcept(StoreFile ... exceptions) {
        ArrayList<StoreFile> result = new ArrayList<StoreFile>();
        result.addAll(Arrays.asList(StoreFile.values()));
        for (StoreFile except : exceptions) {
            result.remove((Object)except);
        }
        return result.toArray(new StoreFile[result.size()]);
    }

    private InputIterable<InputRelationship> legacyRelationshipsAsInput(LegacyStore legacyStore) {
        final LegacyRelationshipStoreReader reader = legacyStore.getRelStoreReader();
        return new InputIterable<InputRelationship>(){

            @Override
            public InputIterator<InputRelationship> iterator() {
                Iterator<RelationshipRecord> source;
                try {
                    source = reader.iterator(0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                final StoreSourceTraceability traceability = new StoreSourceTraceability("legacy relationships", reader.getRecordSize());
                return new SourceInputIterator<InputRelationship, RelationshipRecord>((SourceTraceability)traceability){

                    @Override
                    public boolean hasNext() {
                        return source.hasNext();
                    }

                    @Override
                    public InputRelationship next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        RelationshipRecord record = (RelationshipRecord)source.next();
                        InputRelationship result = new InputRelationship("legacy store", record.getId(), record.getId() * 34L, InputEntity.NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                        result.setSpecificId(record.getId());
                        traceability.atId(record.getId());
                        return result;
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    private InputIterable<InputNode> legacyNodesAsInput(LegacyStore legacyStore) {
        final LegacyNodeStoreReader reader = legacyStore.getNodeStoreReader();
        return new InputIterable<InputNode>(){

            @Override
            public InputIterator<InputNode> iterator() {
                Iterator<NodeRecord> source;
                try {
                    source = reader.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                final StoreSourceTraceability traceability = new StoreSourceTraceability("legacy nodes", reader.getRecordSize());
                return new SourceInputIterator<InputNode, NodeRecord>((SourceTraceability)traceability){

                    @Override
                    public boolean hasNext() {
                        return source.hasNext();
                    }

                    @Override
                    public InputNode next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        NodeRecord record = (NodeRecord)source.next();
                        traceability.atId(record.getId());
                        return new InputNode("legacy store", record.getId(), record.getId() * 15L, record.getId(), InputEntity.NO_PROPERTIES, record.getNextProp(), InputNode.NO_LABELS, record.getLabelField());
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom) throws IOException {
        StoreFile[] idFilesToDelete;
        List<StoreFile> filesToMove;
        switch (versionToUpgradeFrom) {
            case "v0.A.0": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE, StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT);
                idFilesToDelete = this.allExcept(StoreFile.RELATIONSHIP_GROUP_STORE);
                break;
            }
            case "v0.A.1": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.RELATIONSHIP_STORE, StoreFile.RELATIONSHIP_GROUP_STORE, StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT);
                idFilesToDelete = this.allExcept(StoreFile.RELATIONSHIP_GROUP_STORE);
                break;
            }
            case "v0.A.3": {
                filesToMove = Arrays.asList(StoreFile.NODE_STORE, StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT, StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE);
                idFilesToDelete = new StoreFile[]{};
                break;
            }
            case "v0.A.5": {
                filesToMove = Collections.emptyList();
                idFilesToDelete = new StoreFile[]{};
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + versionToUpgradeFrom);
            }
        }
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, Iterables.iterable(idFilesToDelete), true, false, StoreFileType.ID);
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, filesToMove, true, true, StoreFileType.values());
        StoreFile.removeTrailers(versionToUpgradeFrom, this.fileSystem, storeDir, this.pageCache.pageSize());
        File neoStore = new File(storeDir, "neostore");
        long logVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LOG_VERSION);
        long lastCommittedTx = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir);
        this.legacyLogs.deleteUnusedLogFiles(storeDir);
        new StoreMigratorCheckPointer(storeDir, this.fileSystem).checkPoint(logVersion, lastCommittedTx);
    }

    @Override
    public void rebuildCounts(File storeDir, String versionToMigrateFrom) throws IOException {
        switch (versionToMigrateFrom) {
            case "v0.A.0": 
            case "v0.A.1": {
                break;
            }
            case "v0.A.3": 
            case "v0.A.5": {
                Iterable<StoreFile> countsStoreFiles = Iterables.iterable(StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT);
                StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, storeDir, storeDir, countsStoreFiles, true, false, StoreFileType.STORE);
                File neoStore = new File(storeDir, "neostore");
                long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
                this.rebuildCountsFromScratch(storeDir, lastTxId, this.pageCache);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version to upgrade from: " + versionToMigrateFrom);
            }
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        TransactionId lastTxInfo = this.readLastTxInformation(migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        LogPosition logPosition = this.readLastTxLogPosition(migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, logPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong("v0.A.6"));
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }
}

