/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;

public enum FileOperation {
    COPY{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, boolean skipNonExistentFromFile, File toDirectory, boolean overwrite) throws IOException {
            File fromFile = this.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile != null) {
                fs.copyFile(fromFile, this.toFile(fs, toDirectory, fileName, overwrite));
            }
        }
    }
    ,
    MOVE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File fromDirectory, boolean skipNonExistentFromFile, File toDirectory, boolean overwrite) throws IOException {
            File fromFile = this.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile != null) {
                this.toFile(fs, toDirectory, fileName, overwrite);
                fs.moveToDirectory(fromFile, toDirectory);
            }
        }
    }
    ,
    DELETE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, File directory, boolean skipNonExistentFromFile, File unusedFile, boolean unusedBoolean) throws IOException {
            File file = this.fromFile(fs, directory, fileName, skipNonExistentFromFile);
            if (file != null) {
                fs.deleteFile(file);
            }
        }
    };


    public abstract void perform(FileSystemAbstraction var1, String var2, File var3, boolean var4, File var5, boolean var6) throws IOException;

    protected File fromFile(FileSystemAbstraction fs, File directory, String name, boolean skipNonExistent) {
        File fromFile = new File(directory, name);
        if (skipNonExistent && !fs.fileExists(fromFile)) {
            return null;
        }
        return fromFile;
    }

    protected File toFile(FileSystemAbstraction fs, File directory, String name, boolean overwrite) {
        File file = new File(directory, name);
        if (overwrite) {
            fs.deleteFile(file);
        }
        return file;
    }
}

