/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.api.store.PropertyBlockCursor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyRecordCursor {
    private long currentRecordId;
    private PropertyStore propertyStore;
    private PropertyRecord record;

    public PropertyRecordCursor(PropertyRecord record, PropertyStore propertyStore) {
        this.record = record;
        this.propertyStore = propertyStore;
    }

    public void init(long firstRecordId) {
        this.currentRecordId = firstRecordId;
    }

    public boolean next() {
        if (this.currentRecordId != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.record.setId(this.currentRecordId);
            this.propertyStore.getRecord(this.record);
            this.currentRecordId = this.record.getNextProp();
            return true;
        }
        return false;
    }

    public PropertyRecord getRecord() {
        return this.record;
    }

    public void close() {
    }

    public PropertyBlockCursor getPropertyBlockCursor(PropertyBlockCursor propertyBlockCursor) {
        if (propertyBlockCursor == null) {
            propertyBlockCursor = new PropertyBlockCursor(this.propertyStore);
        }
        return this.record.getPropertyBlockCursor(propertyBlockCursor);
    }
}

