/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.spi.SimpleKernelContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.udc.UsageDataKeys;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdGeneratorFactory;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.IoTracer;

public class BatchingNeoStores
implements AutoCloseable,
NeoStoresSupplier {
    private final FileSystemAbstraction fileSystem;
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyRepository;
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelRepository;
    private final BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository;
    private final LogProvider logProvider;
    private final File storeDir;
    private final Config neo4jConfig;
    private final PageCache pageCache;
    private final NeoStores neoStores;
    private final LifeSupport life = new LifeSupport();
    private final LabelScanStore labelScanStore;
    private final IoTracer ioTracer;

    public BatchingNeoStores(FileSystemAbstraction fileSystem, File storeDir, Configuration config, LogService logService, AdditionalInitialIds initialIds, Config dbConfig) {
        this.fileSystem = fileSystem;
        this.logProvider = logService.getInternalLogProvider();
        this.storeDir = storeDir;
        long mappedMemory = config.pageCacheMemory();
        int pageSize = BatchingNeoStores.calculateOptimalPageSize(mappedMemory, 60);
        this.neo4jConfig = new Config(MapUtil.stringMap(dbConfig.getParams(), GraphDatabaseSettings.dense_node_threshold.name(), String.valueOf(config.denseNodeThreshold()), GraphDatabaseSettings.pagecache_memory.name(), String.valueOf(mappedMemory), GraphDatabaseSettings.mapped_memory_page_size.name(), String.valueOf(pageSize)), GraphDatabaseSettings.class);
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        this.pageCache = BatchingNeoStores.createPageCache(fileSystem, this.neo4jConfig, this.logProvider, (PageCacheTracer)tracer);
        this.ioTracer = new IoTracer((PageCacheTracer)tracer){
            final /* synthetic */ PageCacheTracer val$tracer;
            {
                this.val$tracer = pageCacheTracer;
            }

            @Override
            public long countBytesWritten() {
                return this.val$tracer.countBytesWritten();
            }
        };
        this.neoStores = this.newNeoStores(this.pageCache);
        if (this.alreadyContainsData(this.neoStores)) {
            this.neoStores.close();
            throw new IllegalStateException(storeDir + " already contains data, cannot do import here");
        }
        try {
            this.neoStores.rebuildCountStoreIfNeeded();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.neoStores.getMetaDataStore().setLastCommittedAndClosedTransactionId(initialIds.lastCommittedTransactionId(), initialIds.lastCommittedTransactionChecksum(), 0L, initialIds.lastCommittedTransactionLogByteOffset(), initialIds.lastCommittedTransactionLogVersion());
        this.propertyKeyRepository = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository(this.neoStores.getPropertyKeyTokenStore(), initialIds.highPropertyKeyTokenId());
        this.labelRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.neoStores.getLabelTokenStore(), initialIds.highLabelTokenId());
        this.relationshipTypeRepository = new BatchingTokenRepository.BatchingRelationshipTypeTokenRepository(this.neoStores.getRelationshipTypeTokenStore(), initialIds.highRelationshipTypeTokenId());
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency(this.neo4jConfig);
        dependencies.satisfyDependency(fileSystem);
        dependencies.satisfyDependency(this);
        dependencies.satisfyDependency(logService);
        SimpleKernelContext kernelContext = new SimpleKernelContext(this.fileSystem, this.storeDir, UsageDataKeys.OperationalMode.single);
        KernelExtensions extensions = this.life.add(new KernelExtensions(kernelContext, Service.load(KernelExtensionFactory.class), dependencies, UnsatisfiedDependencyStrategies.ignore()));
        this.life.start();
        this.labelScanStore = this.life.add(extensions.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
    }

    static int calculateOptimalPageSize(long memorySize, int numberOfPages) {
        int lowest = (int)ByteUnit.kibiBytes((long)8L);
        for (int pageSize = (int)ByteUnit.mebiBytes((long)8L); pageSize > lowest; pageSize >>>= 1) {
            if (memorySize / (long)pageSize < (long)numberOfPages) continue;
            return pageSize;
        }
        return lowest;
    }

    private static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogProvider log, PageCacheTracer tracer) {
        return new ConfiguringPageCacheFactory(fileSystem, config, tracer, log.getLog(BatchingNeoStores.class)).getOrCreatePageCache();
    }

    private boolean alreadyContainsData(NeoStores neoStores) {
        return neoStores.getNodeStore().getHighId() > 0L || neoStores.getRelationshipStore().getHighId() > 0L;
    }

    public static void createStore(FileSystemAbstraction fileSystem, String storeDir, Config dbConfig) throws IOException {
        try (PageCache pageCache = BatchingNeoStores.createPageCache(fileSystem, dbConfig, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL);){
            StoreFactory storeFactory = new StoreFactory(fileSystem, new File(storeDir), pageCache, (LogProvider)NullLogProvider.getInstance());
            try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
                neoStores.getMetaDataStore();
                neoStores.getLabelTokenStore();
                neoStores.getNodeStore();
                neoStores.getPropertyStore();
                neoStores.getRelationshipGroupStore();
                neoStores.getRelationshipStore();
                neoStores.getSchemaStore();
            }
        }
    }

    private NeoStores newNeoStores(PageCache pageCache) {
        BatchingIdGeneratorFactory idGeneratorFactory = new BatchingIdGeneratorFactory(this.fileSystem);
        StoreFactory storeFactory = new StoreFactory(this.storeDir, this.neo4jConfig, idGeneratorFactory, pageCache, this.fileSystem, this.logProvider);
        return storeFactory.openAllNeoStores(true);
    }

    public IoTracer getIoTracer() {
        return this.ioTracer;
    }

    public NodeStore getNodeStore() {
        return this.neoStores.getNodeStore();
    }

    public PropertyStore getPropertyStore() {
        return this.neoStores.getPropertyStore();
    }

    public BatchingTokenRepository.BatchingPropertyKeyTokenRepository getPropertyKeyRepository() {
        return this.propertyKeyRepository;
    }

    public BatchingTokenRepository.BatchingLabelTokenRepository getLabelRepository() {
        return this.labelRepository;
    }

    public BatchingTokenRepository.BatchingRelationshipTypeTokenRepository getRelationshipTypeRepository() {
        return this.relationshipTypeRepository;
    }

    public RelationshipStore getRelationshipStore() {
        return this.neoStores.getRelationshipStore();
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return this.neoStores.getRelationshipGroupStore();
    }

    public CountsTracker getCountsStore() {
        return this.neoStores.getCounts();
    }

    @Override
    public void close() throws IOException {
        this.propertyKeyRepository.close();
        this.labelRepository.close();
        this.relationshipTypeRepository.close();
        this.life.shutdown();
        this.neoStores.close();
        this.pageCache.close();
    }

    public long getLastCommittedTransactionId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public NeoStores get() {
        return this.neoStores;
    }
}

