/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Arrays;
import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class InputNodeDeserialization
extends InputEntityDeserialization<InputNode> {
    private final Header header;
    private final Groups groups;
    private final boolean idsAreExternal;
    private Group group;
    private Object id;
    private String[] labels = new String[10];
    private int labelsCursor;

    public InputNodeDeserialization(SourceTraceability source, Header header, Groups groups, boolean idsAreExternal) {
        super(source);
        this.header = header;
        this.groups = groups;
        this.idsAreExternal = idsAreExternal;
    }

    @Override
    public void initialize() {
        Header.Entry idEntry = this.header.entry(Type.ID);
        this.group = this.groups.getOrCreate(idEntry != null ? idEntry.groupName() : null);
    }

    @Override
    public void handle(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case ID: {
                if (entry.name() != null && this.idsAreExternal) {
                    this.addProperty(entry.name(), value);
                }
                this.id = value;
                break;
            }
            case LABEL: {
                this.addLabels(value);
                break;
            }
            default: {
                super.handle(entry, value);
            }
        }
    }

    @Override
    public InputNode materialize() {
        return new InputNode(this.source.sourceDescription(), this.source.lineNumber(), this.source.position(), this.group, this.id, this.properties(), null, this.labels(), null);
    }

    @Override
    public void clear() {
        super.clear();
        this.labelsCursor = 0;
        this.id = null;
    }

    private void ensureLabelsCapacity(int length) {
        if (length > this.labels.length) {
            this.labels = Arrays.copyOf(this.labels, length);
        }
    }

    private void addLabels(Object value) {
        if (value instanceof String) {
            this.ensureLabelsCapacity(this.labelsCursor + 1);
            this.labels[this.labelsCursor++] = (String)value;
        } else if (value instanceof String[]) {
            String[] labelsToAdd = (String[])value;
            this.ensureLabelsCapacity(this.labelsCursor + labelsToAdd.length);
            for (String label : (String[])value) {
                this.labels[this.labelsCursor++] = label;
            }
        } else {
            throw new IllegalArgumentException("Unexpected label value type " + value.getClass() + ": " + value);
        }
    }

    private String[] labels() {
        return this.labelsCursor > 0 ? Arrays.copyOf(this.labels, this.labelsCursor) : InputEntity.NO_LABELS;
    }
}

