/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.List;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.impl.core.InMemoryTokenCache;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenFactory;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class DelegatingTokenHolder<TOKEN extends Token>
extends LifecycleAdapter
implements TokenHolder<TOKEN> {
    protected InMemoryTokenCache<TOKEN> tokenCache = new InMemoryTokenCache(this.getClass());
    private final TokenCreator tokenCreator;
    private final TokenFactory<TOKEN> tokenFactory;

    public DelegatingTokenHolder(TokenCreator tokenCreator, TokenFactory<TOKEN> tokenFactory) {
        this.tokenCreator = tokenCreator;
        this.tokenFactory = tokenFactory;
    }

    @Override
    public void setInitialTokens(List<TOKEN> tokens) throws NonUniqueTokenException {
        this.tokenCache.clear();
        this.tokenCache.putAll(tokens);
    }

    @Override
    public void addToken(TOKEN token) throws NonUniqueTokenException {
        this.tokenCache.put(token);
    }

    @Override
    public int getOrCreateId(String name) {
        Integer id = this.tokenCache.getId(name);
        if (id != null) {
            return id;
        }
        try {
            id = this.createToken(name);
            return id;
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create token", e);
        }
    }

    private synchronized int createToken(String name) throws KernelException {
        Integer id = this.tokenCache.getId(name);
        if (id != null) {
            return id;
        }
        id = this.tokenCreator.getOrCreate(name);
        try {
            this.tokenCache.put((Token)this.tokenFactory.newToken(name, id));
        }
        catch (NonUniqueTokenException e) {
            throw new IllegalStateException("Newly created token should be unique.", e);
        }
        return id;
    }

    @Override
    public TOKEN getTokenById(int id) throws TokenNotFoundException {
        TOKEN result = this.getTokenByIdOrNull(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    @Override
    public TOKEN getTokenByIdOrNull(int id) {
        return this.tokenCache.getToken(id);
    }

    @Override
    public int getIdByName(String name) {
        Integer id = this.tokenCache.getId(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public Iterable<TOKEN> getAllTokens() {
        return this.tokenCache.allTokens();
    }
}

