/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.StandardExpander;

public class PathExpanderBuilder {
    private final StandardExpander expander;

    public static PathExpanderBuilder empty() {
        return new PathExpanderBuilder(StandardExpander.EMPTY);
    }

    public static PathExpanderBuilder allTypesAndDirections() {
        return new PathExpanderBuilder(StandardExpander.DEFAULT);
    }

    public static PathExpanderBuilder allTypes(Direction direction) {
        return new PathExpanderBuilder(StandardExpander.create(direction));
    }

    public PathExpanderBuilder add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    public PathExpanderBuilder add(RelationshipType type, Direction direction) {
        return new PathExpanderBuilder(this.expander.add(type, direction));
    }

    public PathExpanderBuilder remove(RelationshipType type) {
        return new PathExpanderBuilder(this.expander.remove(type));
    }

    public PathExpanderBuilder addNodeFilter(Predicate<? super Node> filter) {
        return new PathExpanderBuilder((StandardExpander)this.expander.addNodeFilter((Predicate)filter));
    }

    public PathExpanderBuilder addRelationshipFilter(Predicate<? super Relationship> filter) {
        return new PathExpanderBuilder((StandardExpander)this.expander.addRelationshipFilter((Predicate)filter));
    }

    public <STATE> PathExpander<STATE> build() {
        return this.expander;
    }

    private PathExpanderBuilder(StandardExpander expander) {
        this.expander = expander;
    }
}

