/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdRange;

public class BatchingIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, IdGenerator> idGenerators = new EnumMap<IdType, IdGenerator>(IdType.class);
    private final FileSystemAbstraction fs;

    public BatchingIdGeneratorFactory(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public IdGenerator open(File fileName, int grabSize, IdType idType, long highId) {
        IdGenerator generator = this.idGenerators.get((Object)idType);
        if (generator == null) {
            generator = new BatchingIdGenerator(this.fs, fileName, highId);
            this.idGenerators.put(idType, generator);
        }
        return generator;
    }

    @Override
    public void create(File fileName, long highId, boolean throwIfFileExists) {
    }

    @Override
    public IdGenerator get(IdType idType) {
        return this.idGenerators.get((Object)idType);
    }

    private static class BatchingIdGenerator
    implements IdGenerator {
        private long highId;
        private final FileSystemAbstraction fs;
        private final File fileName;

        public BatchingIdGenerator(FileSystemAbstraction fs, File fileName, long highId) {
            this.fs = fs;
            this.fileName = fileName;
            this.highId = highId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long nextId() {
            try {
                long l = this.highId;
                return l;
            }
            finally {
                ++this.highId;
            }
        }

        @Override
        public IdRange nextIdBatch(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setHighId(long id) {
            this.highId = id;
        }

        @Override
        public long getHighId() {
            return this.highId;
        }

        @Override
        public void freeId(long id) {
        }

        @Override
        public void close() {
            IdGeneratorImpl.createGenerator(this.fs, this.fileName, this.highId, false);
        }

        @Override
        public long getNumberOfIdsInUse() {
            return this.highId;
        }

        @Override
        public long getDefragCount() {
            return 0L;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return this.getHighId() - 1L;
        }
    }
}

