/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.executor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public interface ParkStrategy {
    public void park(Thread var1);

    public void unpark(Thread var1);

    public static class Park
    implements ParkStrategy {
        private final long nanos;

        public Park(int millis) {
            this.nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        }

        @Override
        public void park(Thread thread) {
            LockSupport.parkNanos(this.nanos);
        }

        @Override
        public void unpark(Thread thread) {
            LockSupport.unpark(thread);
        }
    }
}

