/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

public class StoreMigratorCheckPointer {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;

    public StoreMigratorCheckPointer(File storeDir, FileSystemAbstraction fileSystem) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
    }

    public void checkPoint(long logVersion, long lastCommittedTx) throws IOException {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, this.fileSystem);
        File logFileForVersion = logFiles.getLogFileForVersion(logVersion);
        if (!this.fileSystem.fileExists(logFileForVersion)) {
            this.fileSystem.create(logFileForVersion);
            LogHeaderWriter.writeLogHeader(this.fileSystem, logFileForVersion, logVersion, lastCommittedTx);
        }
        try (PhysicalLogVersionedStoreChannel storeChannel = PhysicalLogFile.openForVersion(logFiles, this.fileSystem, logVersion);){
            long offset = storeChannel.size();
            storeChannel.position(offset);
            try (PhysicalWritableLogChannel channel = new PhysicalWritableLogChannel(storeChannel);){
                TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter(channel, new CommandWriter(channel)));
                writer.checkPoint(new LogPosition(logVersion, offset));
            }
        }
    }
}

